package com.yunniu.farming.app;

import com.yunniu.farming.common.plugin.PageInfo;
import com.yunniu.farming.result.Result;
import com.yunniu.farming.webadmin.model.GroupBuy;
import com.yunniu.farming.webadmin.service.GroupBuyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author zyf
 * @date 2023/5/12
 * @apiNote
 */
@Controller
@RequestMapping("/app/groupBuy")
public class GroupBuyAppController {

    @Autowired
    private GroupBuyService groupBuyService;

    /**
     * 分页查询
     * @return
     */
    @RequestMapping(value = "/findPageList", method = RequestMethod.POST)
    @ResponseBody
    public Result findPageList(@RequestBody GroupBuy item) {
        //这里对返回对象用Map处理，map.pageinfo=>分页信息；map.items=>结果数据集；
        Map<String,Object> rmap = new HashMap<String,Object>();

        //传入当前页数，适配PC端Layui分页
        if (item.getCurpage() != null || item.getPagesize() != null) {
            PageInfo pinfo = new PageInfo();

            if (item.getCurpage() != null) {
                pinfo.setCurPage(item.getCurpage());
            }
            if (item.getPagesize() != null) {
                pinfo.setPageSize(item.getPagesize());
            }
            item.setPageinfo(pinfo);
        }
        // 1.查询前 需要对分页对象 做处理，主要是 分页 开始记录数 limit arg0开始记录，arg1每页几条记录
        PageInfo pinfo = item.getPageinfo();
        if (pinfo == null) {
            pinfo = new PageInfo();
            item.setPageinfo(pinfo);
        } else {
            // 分页开始记录数
            int curRecord = (pinfo.getCurPage() - 1) * pinfo.getPageSize();
            pinfo.setCurRecord(curRecord);
            item.setPageinfo(pinfo);
        }
        item.setAppFlag(1);
        List<GroupBuy> list = groupBuyService.findPageList(item);

        // 3.将查询结果的 分页数据封装后返回
        int totalRs = pinfo.getTotalRecords();        //总记录数
        int totalPs = 0;                            //总页数
        if (totalRs % pinfo.getPageSize() == 0) {        //总页数计算
            totalPs = totalRs / pinfo.getPageSize();
        } else {
            totalPs = 1 + totalRs / pinfo.getPageSize();
        }
        pinfo.setTotalPages(totalPs);
        Integer joinNumber = groupBuyService.findJoinNumber();
        List<String> avatarList = groupBuyService.findavatarList();
        // 4.将分页对象、结果集合 封装后返回前台
        rmap.put("pageinfo", pinfo);
        rmap.put("items", list);
        rmap.put("joinNumber", joinNumber);
        rmap.put("avatarList", avatarList);
        return Result.success(rmap);
    }

    /**
     * 详情
     * @param id 团购id
     * @return
     */
    @RequestMapping(value = "/detail", method = RequestMethod.GET)
    @ResponseBody
    public Result detail(@RequestParam Long id) {
        GroupBuy groupBuy = groupBuyService.findById(id);
        return Result.success(groupBuy);
    }
}
