package com.yunniu.farming.app;

import com.yunniu.farming.result.Result;
import com.yunniu.farming.webadmin.model.DocCatalog;
import com.yunniu.farming.webadmin.service.impl.DocCatalogServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

@Controller
@RequestMapping("/app/catalog")
public class DocCatalogAppController {

	@Autowired
	private DocCatalogServiceImpl catalogServiceImpl;




	/**
	 *  根据 ”多参数“ 查找对象集合
	 */
	@RequestMapping(value = "/findByParam",method = RequestMethod.POST)
	@ResponseBody
	public Result findByParam(@RequestBody DocCatalog item){

		List<DocCatalog> docs = this.catalogServiceImpl.findByParam(item);

		return Result.success(docs);

	}



	/**
	 *  查询商品分类
	 */
	@RequestMapping(value = "/findProInfo",method = RequestMethod.POST)
	@ResponseBody
	public Result findProInfo(@RequestBody DocCatalog item){

		item.setItype(DocCatalog.TYPE_PRO);//商品
		item.setIsshow(1);
		List<DocCatalog> docs = this.catalogServiceImpl.findByParam(item);

		return Result.success(docs);

	}




	/**
	 * @参数查询商品分类，带分类商品
	 */
	@RequestMapping(value = "/findProSubs", method = RequestMethod.POST)
	@ResponseBody
	public Result findProSubs(@RequestBody DocCatalog item){

		item.setItype(DocCatalog.TYPE_PRO);//商品

		return this.catalogServiceImpl.selectProSubByParam(item);

	}


}
