package com.yunniu.farming.app;

import com.alibaba.fastjson.JSONObject;
import com.yunniu.farming.common.plugin.PageInfo;
import com.yunniu.farming.config.ReturnResult;
import com.yunniu.farming.result.Result;
import com.yunniu.farming.util.COSUtil;
import com.yunniu.farming.util.FileUtil;
import com.yunniu.farming.util.OssUtil;
import com.yunniu.farming.webadmin.model.Customer;
import com.yunniu.farming.webadmin.service.impl.CustomerServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


@RestController
@CrossOrigin(origins = "*", maxAge = 3600)
@RequestMapping("/app/customer")
public class CustomerAppController {

    @Autowired
    private CustomerServiceImpl customerService;





    /**
     * APP端注册
     */
    @RequestMapping(value = "/regist",method = RequestMethod.POST)
    @ResponseBody
    public Result regist(@RequestBody Customer u){

        return this.customerService.regist(u);

    }




    /**
     * APP端登录，通过账号+密码
     */
    @RequestMapping(value = "/appLogin",method = RequestMethod.POST)
    @ResponseBody
    public Result appLogin(@RequestBody Customer u) {

        return this.customerService.appLogin(u);

    }



    /**
     * 修改密码
     */
    @RequestMapping(value = "/modifyPassword", method = RequestMethod.POST)
    @ResponseBody
    public Result modifyPassword(@RequestBody Customer u){

        return this.customerService.modifyPassword(u);

    }



    /**
     * 根据 Object对象参数 查找 对象列表
     * 带参 分页查询
     * 注意：这里分页是通过分页插件拦截器实现的，分页相关的数据是通过 查询参数对象 又重新返回了
     * @return
     */
    @RequestMapping(value = "/findPageList", method = RequestMethod.POST)
    @ResponseBody
    public ReturnResult findPageList(@RequestBody Customer doc){

        //这里对返回对象用Map处理，map.pageinfo=>分页信息；map.items=>结果数据集；
        Map<String,Object> rmap = new HashMap<String,Object>();

        // 分页数据处理

        // 传入当前页数，适配PC端Layui分页
        if(doc.getCurpage() != null || doc.getPagesize() != null) {
            PageInfo pinfo = new PageInfo();

            if(doc.getCurpage() != null) {
                pinfo.setCurPage(doc.getCurpage());
            }

            if(doc.getPagesize() != null) {
                pinfo.setPageSize(doc.getPagesize());
            }
            doc.setPageinfo(pinfo);
        }
        // 1.查询前 需要对分页对象 做处理，主要是 分页 开始记录数 limit arg0开始记录，arg1每页几条记录
        PageInfo pinfo = doc.getPageinfo();

        if(pinfo == null) {
            pinfo = new PageInfo();
            doc.setPageinfo(pinfo);
        }else{
            // 分页开始记录数
            int curRecord = (pinfo.getCurPage() - 1) * pinfo.getPageSize();
            pinfo.setCurRecord(curRecord);
            doc.setPageinfo(pinfo);
        }

        // 2.1 执行主表 查询
        List<Customer> docs = this.customerService.selectByParamPageList(doc);

        // 3.将查询结果的 分页数据封装后返回
        //总记录数
        int totalRs = pinfo.getTotalRecords();
        //总页数
        int totalPs = 0;
        //总页数计算
        if(totalRs % pinfo.getPageSize() == 0){
            totalPs = totalRs / pinfo.getPageSize() ;
        }else{
            totalPs = 1 + totalRs / pinfo.getPageSize() ;
        }
        pinfo.setTotalPages(totalPs);

        // 4.将分页对象、结果集 封装后返回前台
        rmap.put("pageinfo", pinfo);
        rmap.put("items", docs);

        return ReturnResult.getSuccessResult(rmap);

    }



    /**
     * FRICE TODO 根据 ”多参数“ 查找对象集合
     *
     * @param Customer Java对象
     * @return ReturnResult 对象列表List<JavaObject>
     */
    @RequestMapping(value = "/findByParam", method = RequestMethod.POST)
    @ResponseBody
    public ReturnResult findByParam(@RequestBody Customer item) {

        // 1. 调用 Service 方法
        List<Customer> docs = this.customerService.findByParam(item);

        // 2. 返回查询结果
        return ReturnResult.getSuccessResult(docs);
    }



    /**
     * 更新
     * @param json
     * @return
     */
    @RequestMapping(value = "/update", method = RequestMethod.POST)
    @ResponseBody
    public Result update(@RequestBody JSONObject json) {
        // 1. 将前台传过来的json对象转换成具有业务属性的 Java 对象
        Customer user = JSONObject.toJavaObject(json, Customer.class);

        // 2. 调用service方法
       return this.customerService.update(user);

    }




    /**
     * 新增、编辑 方法
     *
     * @param JSONObject userJson前台封装的json对象
     * @return ReturnResult
     */
    @RequestMapping(value = "/add", method = RequestMethod.POST)
    @ResponseBody
    public ReturnResult add(@RequestBody JSONObject json) {

        // 1. 将前台传过来的json对象转换成具有业务属性的 Java 对象
        Customer user = JSONObject.toJavaObject(json, Customer.class);

        // 保存订单主表信息
        user = this.customerService.add(user);

        return ReturnResult.getSuccessResult(user);
    }

    /**
     * 根据”对象id“ 查找对象
     *
     * @param id =对象id
     * @return ReturnResult 单个JavaObject
     */
    @RequestMapping(value = "/{id}/findById", method = RequestMethod.GET)
    @ResponseBody
    public ReturnResult findById(@PathVariable Integer id) {

        // 1. 调用Service方法
        Customer item = this.customerService.findByid(id);

        // 2. 返回查询结果
        return ReturnResult.getSuccessResult(item);
    }

    /**
     * 根据”对象id“ 删除对象
     *
     * @param id =对象id
     * @return ReturnResult
     */
    @RequestMapping(value = "/{id}/deleteById", method = RequestMethod.POST)
    @ResponseBody
    public ReturnResult deleteById(@PathVariable Integer id) {
        // 1. 调用Service方法
        int deleteR = this.customerService.deleteByid(id);

        // 2. 返回查询结果
        return ReturnResult.getSuccessResult(deleteR);
    }


    //文件上传
    @RequestMapping(value = "/fileUpload", method = RequestMethod.POST)
    @ResponseBody
    public Result fileUpload(@RequestParam(value = "file", required = false) MultipartFile file) {
        String path = FileUtil.saveFile(file, "catering");
        String url = COSUtil.uploadFileByPath(path);
        return  Result.success("成功", url);
    }

}
