package com.yunniu.farming.app;


import com.yunniu.farming.common.plugin.PageInfo;
import com.yunniu.farming.config.ReturnResult;
import com.yunniu.farming.result.Result;
import com.yunniu.farming.webadmin.model.Article;
import com.yunniu.farming.webadmin.service.impl.ArticleServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.List;
import java.util.Map;


@Controller
@RequestMapping("/app/article")
public class ArticleAppController {
	
	@Autowired
	private ArticleServiceImpl service;
	
	/**
	 * 新增 编辑方法
	 * @param item
	 * @return
	 */
	@RequestMapping(value = "/add", method = RequestMethod.POST)
	@ResponseBody
	public Result add(@RequestBody Article item){
		return this.service.insertSelective(item);
	}


	/**
	 * 新增 编辑方法
	 */
	@RequestMapping(value = "/saveIdea", method = RequestMethod.POST)
	@ResponseBody
	public Result saveIdea(@RequestBody Article item){
		//调用service 方法 返回结果
		return this.service.saveIdea(item);
	}


	/**
	 * 根据 查询参数统计 数量
	 * @return
	 */
	@RequestMapping(value = "/findAdminCount", method = RequestMethod.POST)
	@ResponseBody
	public ReturnResult findAdminCount(@RequestBody Article doc){
		return ReturnResult.getSuccessResult(this.service.findAdminCount(doc));
	}
	/**
	 * 根据 对象id 删除对象
	 * @param id=对象id
	 * @return
	 */
	@RequestMapping(value = "/{id}/deleteByid", method = RequestMethod.GET)
	@ResponseBody
	public ReturnResult deleteByid(@PathVariable Integer id){
		//调用service 方法 返回结果
		return ReturnResult.getSuccessResult(this.service.deleteByid(id));
	}


	/**
	 * 根据 多参数查询集合 是否阅读
	 * @param item 对象
	 * @return ReturnResult 对象列表集合
	 */
	@RequestMapping(value = "/findParamRead", method = RequestMethod.POST)
	@ResponseBody
	public Result findParamRead(@RequestBody Article item){
		//调用service 方法 返回查询结果集
		return this.service.findParamRead(item);
	}
	
	/**
	 * 多参数条件分页
	 * @param doc
	 * @return
	 */
	@RequestMapping("/findPageList")
	@ResponseBody
	public ReturnResult findPageList(@RequestBody Article item){
		
		//这里对返回对象用Map处理，map.pageinfo=>分页信息；map.items=>结果数据集；
		Map<String,Object> rmap = new HashMap<String,Object>();
		
		//传入当前页数，适配PC端Layui分页
		if(item.getCurpage() != null || item.getPagesize() != null) {
			PageInfo pinfo = new PageInfo();
			
			if(item.getCurpage() != null) {
				pinfo.setCurPage(item.getCurpage());
			}
			
			if(item.getPagesize() != null) {
				pinfo.setPageSize(item.getPagesize());
			}
			item.setPageinfo(pinfo);
		}
		
		// 1.查询前 需要对分页对象 做处理，主要是 分页 开始记录数 limit arg0开始记录，arg1每页几条记录
		PageInfo pinfo = item.getPageinfo();
		if(pinfo == null) {
			pinfo = new PageInfo();
			item.setPageinfo(pinfo);
		}else{
			// 分页开始记录数
			int curRecord = (pinfo.getCurPage() - 1) * pinfo.getPageSize();
			pinfo.setCurRecord(curRecord);
			item.setPageinfo(pinfo);
		}
		// 2.1 执行主表 查询
		List<Article> items = this.service.findPageList(item);
		// 3.将查询结果的 分页数据封装后返回
		int totalRs = pinfo.getTotalRecords();		//总记录数
		int totalPs = 0;					  		//总页数
		if(totalRs % pinfo.getPageSize() == 0){		//总页数计算
			totalPs = totalRs / pinfo.getPageSize() ;
		}else{
			totalPs = 1 + totalRs / pinfo.getPageSize() ;
		}
		pinfo.setTotalPages(totalPs);

		// 4.将分页对象、结果集合 封装后返回前台
		rmap.put("pageinfo", pinfo);
		rmap.put("items", items);
		return ReturnResult.getSuccessResult(rmap);
		
	}
	
	/**
	 * 根据 多参数查询对象结合
	 * @param item 对象
	 * @return ReturnResult 对象列表集合
	 */
	@RequestMapping("/findByParam")
	@ResponseBody
	public Result findByParam(@RequestBody Article item){
		//调用service 方法 返回查询结果集
		return this.service.findByParam(item);
	}
	
	/**
	 * 根据”对象id“ 查找对象
	 * @param id=对象id
	 * @return ReturnResult 单个JavaObject
	 */
	@RequestMapping(value = "/{id}/findByid", method = RequestMethod.GET)
	@ResponseBody
	public ReturnResult findByid(@PathVariable Integer id){
		
		//1. 调用Service方法
		 Article  activity= this.service.findByid(id);
		//2. 返回查询结果
		return ReturnResult.getSuccessResult(activity);
	}
}
