package com.yunniu.farming.app;

import com.alibaba.fastjson.JSONObject;
import com.yunniu.farming.common.plugin.PageInfo;
import com.yunniu.farming.config.ReturnResult;
import com.yunniu.farming.webadmin.model.Accountalterrec;
import com.yunniu.farming.webadmin.service.impl.AccountalterrecServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @功能 账户收益
 * @author
 */

@RestController
@CrossOrigin(origins = "*", maxAge = 3600)
@RequestMapping("/app/accountalterrec")
public class AccountalterrecAppController {

	@Autowired
	private AccountalterrecServiceImpl accountalterrecServiceImpl;



	@RequestMapping(value = "/list")
	public String accountalterrec(Model model) {
		return "accountalterrec/list";
	}

	@RequestMapping(value = "/rebateList")
	public String rebateList(Model model) {
		return "userRebate/list";
	}

	@RequestMapping(value = "/saList")
	public String saList(Model model) {
		return "accountalterrec/saList";
	}




	/**
	 * 新增 编辑方法
	 *
	 * @param item
	 * @return 返回封装好的ReturnResult对象 对象中data是所需要的数据
	 */
	@RequestMapping(value = "/add", method = RequestMethod.POST)
	@ResponseBody
	public ReturnResult add(@RequestBody Accountalterrec item) {
		// 调用service 方法 返回结果
		return this.accountalterrecServiceImpl.add(item);
	}


	/**
	 * 根据 对象id 删除对象
	 *
	 * @param id=对象id
	 * @return 返回封装好的returnResult对象 对象中data是数据
	 */
	@RequestMapping(value = "/{id}/deleteById", method = RequestMethod.GET)
	@ResponseBody
	public ReturnResult deleteByid(@PathVariable Integer id) {
		// 调用service 方法 返回结果
		this.accountalterrecServiceImpl.deleteById(id);
		
		return ReturnResult.getSuccessResult();
	}

	/**
	 * 多参数条件分页
	 *
	 * @param item 对象查找的条件 以及分页的参数
	 * @return 封装好的数据集合 都存放在ReturnResult里面的data中
	 */
	@RequestMapping(value = "/findPageList", method = RequestMethod.POST)
	@ResponseBody
	public ReturnResult findPageList(@RequestBody Accountalterrec item) {
		//这里对返回对象用Map处理，map.pageinfo=>分页信息；map.items=>结果数据集；
		Map<String,Object> rmap = new HashMap<String,Object>();

		//传入当前页数，适配PC端Layui分页
		if(item.getCurpage() != null || item.getPagesize() != null) {
			PageInfo pinfo = new PageInfo();

			if(item.getCurpage() != null) {
				pinfo.setCurPage(item.getCurpage());
			}

			if(item.getPagesize() != null) {
				pinfo.setPageSize(item.getPagesize());
			}
			item.setPageinfo(pinfo);
		}

		// 1.查询前 需要对分页对象 做处理，主要是 分页 开始记录数 limit arg0开始记录，arg1每页几条记录
		PageInfo pinfo = item.getPageinfo();
		if(pinfo == null) {
			pinfo = new PageInfo();
			item.setPageinfo(pinfo);
		}else{
			// 分页开始记录数
			int curRecord = (pinfo.getCurPage() - 1) * pinfo.getPageSize();
			pinfo.setCurRecord(curRecord);
			item.setPageinfo(pinfo);
		}
		// 2.1 执行主表 查询
		List<Accountalterrec> items=this.accountalterrecServiceImpl.findPageList(item);

		// 3.将查询结果的 分页数据封装后返回
		int totalRs = pinfo.getTotalRecords();		//总记录数
		int totalPs = 0;					  		//总页数
		if(totalRs % pinfo.getPageSize() == 0){		//总页数计算
			totalPs = totalRs / pinfo.getPageSize() ;
		}else{
			totalPs = 1 + totalRs / pinfo.getPageSize() ;
		}
		pinfo.setTotalPages(totalPs);

		// 4.将分页对象、结果集合 封装后返回前台
		rmap.put("pageinfo", pinfo);
		rmap.put("items", items);
		return ReturnResult.getSuccessResult(rmap);
	}



    /**
     * FRICE TODO 根据 ”多参数“ 查找对象集合
     *
     * @param item Java对象
     * @return ReturnResult 对象列表List<JavaObject>
     */
    @RequestMapping(value = "/findByParam", method = RequestMethod.POST)
    @ResponseBody
    public ReturnResult findByParam(@RequestBody Accountalterrec item) {

        // 1. 调用 Service 方法
        List<Accountalterrec> docs = this.accountalterrecServiceImpl.findByParam(item);

        // 2. 返回查询结果
        return ReturnResult.getSuccessResult(docs);
    }



	/**
	 * 根据”对象id“ 查找对象
	 *
	 * @param id=对象id
	 * @return ReturnResult 单个JavaObject
	 */
	@RequestMapping(value = "/{id}/findById", method = RequestMethod.GET)
	@ResponseBody
	public ReturnResult findById(@PathVariable Integer id) {
		Accountalterrec m = this.accountalterrecServiceImpl.findById(id);
		return ReturnResult.getSuccessResult(m);
	}



	/**
	 * 根据”对象id“ 查询余额
	 *
	 * @param id=对象id
	 * @return ReturnResult 单个JavaObject
	 */
	@RequestMapping(value = "/findBalanceByParam", method = RequestMethod.POST)
	@ResponseBody
	public ReturnResult findBalanceByParam(@RequestBody Accountalterrec item) {

		// 1. 调用Service方法
		return this.accountalterrecServiceImpl.findBalanceByid(item);

	}


	/**
	 * 提现申请
	 * @param
	 * @return ReturnResult
	 */
	@RequestMapping(value = "/toAuditWithDraw", method = RequestMethod.POST)
	@ResponseBody
	public ReturnResult toAuditWithDraw(@RequestBody JSONObject json)throws Exception{

		Accountalterrec rec = JSONObject.toJavaObject(json,Accountalterrec.class);

		return this.accountalterrecServiceImpl.toAuditWithDraw(rec);
	}


	/**
	 * @提现申请 审核处理：通过或拒绝
	 * @param
	 * @return ReturnResult
	 */
	@RequestMapping(value = "/auditWithDraw", method = RequestMethod.POST)
	@ResponseBody
	public ReturnResult auditWithDraw(@RequestBody JSONObject json){
		//1. 将前台传过来的json对象转换成具有业务属性的 Java 对象
		Accountalterrec user = JSONObject.toJavaObject(json,Accountalterrec.class);

		//1. 调用Service方法
		return this.accountalterrecServiceImpl.auditWithDraw(user);
	}


	/**
	 * 统计个人收益
	 */
	@RequestMapping(value = "/countShouYi", method = RequestMethod.POST)
	@ResponseBody
	public ReturnResult countShouYi(@RequestBody JSONObject json){
		//1. 将前台传过来的json对象转换成具有业务属性的 Java 对象
		Accountalterrec accountalterrec = JSONObject.toJavaObject(json,Accountalterrec.class);
		//2. 调用service方法
		ReturnResult result = this.accountalterrecServiceImpl.countShouYi(accountalterrec);

		return result;
	}



	/**
	 * 统计团队津贴
	 */
	@RequestMapping(value = "/countTeamJt", method = RequestMethod.POST)
	@ResponseBody
	public ReturnResult countTeamJt(@RequestBody JSONObject json){
		//1. 将前台传过来的json对象转换成具有业务属性的 Java 对象
		Accountalterrec accountalterrec = JSONObject.toJavaObject(json,Accountalterrec.class);
		//2. 调用service方法
		ReturnResult result = this.accountalterrecServiceImpl.countTeamJt(accountalterrec);

		return result;
	}



	/**
	 * 统计管理津贴
	 */
	@RequestMapping(value = "/countManageJt", method = RequestMethod.POST)
	@ResponseBody
	public ReturnResult countManageJt(@RequestBody JSONObject json){
		//1. 将前台传过来的json对象转换成具有业务属性的 Java 对象
		Accountalterrec accountalterrec = JSONObject.toJavaObject(json,Accountalterrec.class);
		//2. 调用service方法
		ReturnResult result = this.accountalterrecServiceImpl.countManageJt(accountalterrec);

		return result;
	}


}
