package com.ruoyi.school.paper.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ruoyi.common.core.domain.PageQuery;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.school.paper.domain.DbTestPaperRecordDetail;
import com.ruoyi.school.paper.domain.bo.DbTestPaperRecordDetailBo;
import com.ruoyi.school.paper.domain.vo.DbTestPaperRecordDetailVo;
import com.ruoyi.school.paper.mapper.DbTestPaperRecordDetailMapper;
import com.ruoyi.school.paper.service.IDbTestPaperRecordDetailService;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * 答题记录详情Service业务层处理
 *
 * @author zyf
 * @date 2023-07-20
 */
@RequiredArgsConstructor
@Service
public class DbTestPaperRecordDetailServiceImpl implements IDbTestPaperRecordDetailService {

    private final DbTestPaperRecordDetailMapper baseMapper;

    /**
     * 查询答题记录详情
     */
    @Override
    public DbTestPaperRecordDetailVo queryById(Long id) {
        return baseMapper.selectVoById(id);
    }

    /**
     * 查询答题记录详情列表
     */
    @Override
    public TableDataInfo<DbTestPaperRecordDetailVo> queryPageList(DbTestPaperRecordDetailBo bo, PageQuery pageQuery) {

        Page<DbTestPaperRecordDetailVo> result = baseMapper.queryPageList(pageQuery.build(), bo);
        return TableDataInfo.build(result);
    }

    /**
     * 查询答题记录详情列表
     */
    @Override
    public List<DbTestPaperRecordDetailVo> queryList(DbTestPaperRecordDetailBo bo) {
        LambdaQueryWrapper<DbTestPaperRecordDetail> lqw = buildQueryWrapper(bo);
        return baseMapper.selectVoList(lqw);
    }

    private LambdaQueryWrapper<DbTestPaperRecordDetail> buildQueryWrapper(DbTestPaperRecordDetailBo bo) {
        Map<String, Object> params = bo.getParams();
        LambdaQueryWrapper<DbTestPaperRecordDetail> lqw = Wrappers.lambdaQuery();
        lqw.eq(bo.getRecordId() != null, DbTestPaperRecordDetail::getRecordId, bo.getRecordId());
        lqw.eq(bo.getQuestionBankId() != null, DbTestPaperRecordDetail::getQuestionBankId, bo.getQuestionBankId());
        lqw.eq(StringUtils.isNotBlank(bo.getAnswer()), DbTestPaperRecordDetail::getAnswer, bo.getAnswer());
        lqw.eq(bo.getScore() != null, DbTestPaperRecordDetail::getScore, bo.getScore());
        lqw.eq(bo.getGood() != null, DbTestPaperRecordDetail::getGood, bo.getGood());
        lqw.eq(bo.getStatus() != null, DbTestPaperRecordDetail::getStatus, bo.getStatus());
        lqw.eq(bo.getCerateTime() != null, DbTestPaperRecordDetail::getCreateTime, bo.getCerateTime());
        return lqw;
    }

    /**
     * 新增答题记录详情
     */
    @Override
    public Boolean insertByBo(DbTestPaperRecordDetailBo bo) {
        DbTestPaperRecordDetail add = BeanUtil.toBean(bo, DbTestPaperRecordDetail.class);
        validEntityBeforeSave(add);
        boolean flag = baseMapper.insert(add) > 0;
        if (flag) {
            bo.setId(add.getId());
        }
        return flag;
    }

    /**
     * 修改答题记录详情
     */
    @Override
    public Boolean updateByBo(DbTestPaperRecordDetailBo bo) {
        DbTestPaperRecordDetail update = BeanUtil.toBean(bo, DbTestPaperRecordDetail.class);
        validEntityBeforeSave(update);
        return baseMapper.updateById(update) > 0;
    }

    /**
     * 保存前的数据校验
     */
    private void validEntityBeforeSave(DbTestPaperRecordDetail entity) {
        //TODO 做一些数据校验,如唯一约束
    }

    /**
     * 批量删除答题记录详情
     */
    @Override
    public Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid) {
        if (isValid) {
            //TODO 做一些业务上的校验,判断是否需要校验
        }
        return baseMapper.deleteBatchIds(ids) > 0;
    }

    @Override
    public boolean saveBatch(Collection<DbTestPaperRecordDetail> collection) {
        return baseMapper.insertBatch(collection);
    }
}
