package com.ruoyi.school.paper.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.core.domain.PageQuery;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import com.ruoyi.school.paper.domain.bo.DbQuestionTypeBo;
import com.ruoyi.school.paper.domain.vo.DbQuestionTypeVo;
import com.ruoyi.school.paper.domain.DbQuestionType;
import com.ruoyi.school.paper.mapper.DbQuestionTypeMapper;
import com.ruoyi.school.paper.service.IDbQuestionTypeService;

import java.util.List;
import java.util.Map;
import java.util.Collection;

/**
 * 题型Service业务层处理
 *
 * @author zyf
 * @date 2023-07-20
 */
@RequiredArgsConstructor
@Service
public class DbQuestionTypeServiceImpl implements IDbQuestionTypeService {

    private final DbQuestionTypeMapper baseMapper;

    /**
     * 查询题型
     */
    @Override
    public DbQuestionTypeVo queryById(Long id){
        return baseMapper.selectVoById(id);
    }

    /**
     * 查询题型列表
     */
    @Override
    public TableDataInfo<DbQuestionTypeVo> queryPageList(DbQuestionTypeBo bo, PageQuery pageQuery) {
        LambdaQueryWrapper<DbQuestionType> lqw = buildQueryWrapper(bo);
        Page<DbQuestionTypeVo> result = baseMapper.selectVoPage(pageQuery.build(), lqw);
        return TableDataInfo.build(result);
    }

    /**
     * 查询题型列表
     */
    @Override
    public List<DbQuestionTypeVo> queryList(DbQuestionTypeBo bo) {
        LambdaQueryWrapper<DbQuestionType> lqw = buildQueryWrapper(bo);
        return baseMapper.selectVoList(lqw);
    }

    private LambdaQueryWrapper<DbQuestionType> buildQueryWrapper(DbQuestionTypeBo bo) {
        Map<String, Object> params = bo.getParams();
        LambdaQueryWrapper<DbQuestionType> lqw = Wrappers.lambdaQuery();
        lqw.eq(bo.getParentId() != null, DbQuestionType::getParentId, bo.getParentId());
        lqw.eq(StringUtils.isNotBlank(bo.getTypeValue()), DbQuestionType::getTypeValue, bo.getTypeValue());
        lqw.eq(bo.getTypeStatus() != null, DbQuestionType::getTypeStatus, bo.getTypeStatus());
        return lqw;
    }

    /**
     * 新增题型
     */
    @Override
    public Boolean insertByBo(DbQuestionTypeBo bo) {
        DbQuestionType add = BeanUtil.toBean(bo, DbQuestionType.class);
        validEntityBeforeSave(add);
        boolean flag = baseMapper.insert(add) > 0;
        if (flag) {
            bo.setId(add.getId());
        }
        return flag;
    }

    /**
     * 修改题型
     */
    @Override
    public Boolean updateByBo(DbQuestionTypeBo bo) {
        DbQuestionType update = BeanUtil.toBean(bo, DbQuestionType.class);
        validEntityBeforeSave(update);
        return baseMapper.updateById(update) > 0;
    }

    /**
     * 保存前的数据校验
     */
    private void validEntityBeforeSave(DbQuestionType entity){
        //TODO 做一些数据校验,如唯一约束
    }

    /**
     * 批量删除题型
     */
    @Override
    public Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid) {
        if(isValid){
            //TODO 做一些业务上的校验,判断是否需要校验
        }
        return baseMapper.deleteBatchIds(ids) > 0;
    }
}
