package com.ruoyi.school.paper.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ruoyi.common.core.domain.PageQuery;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.school.paper.domain.DbQuestionBankTestPaper;
import com.ruoyi.school.paper.domain.bo.DbQuestionBankTestPaperBo;
import com.ruoyi.school.paper.domain.bo.TestPaperAnswerBo;
import com.ruoyi.school.paper.domain.vo.DbQuestionBankTestPaperVo;
import com.ruoyi.school.paper.domain.vo.TestQuestionItemVo;
import com.ruoyi.school.paper.mapper.DbQuestionBankTestPaperMapper;
import com.ruoyi.school.paper.service.IDbQuestionBankTestPaperService;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * 试卷题库主Service业务层处理
 *
 * @author zyf
 * @date 2023-07-20
 */
@RequiredArgsConstructor
@Service
public class DbQuestionBankTestPaperServiceImpl implements IDbQuestionBankTestPaperService {

    private final DbQuestionBankTestPaperMapper baseMapper;

    /**
     * 查询试卷题库主
     */
    @Override
    public DbQuestionBankTestPaperVo queryById(Long id) {
        return baseMapper.selectVoById(id);
    }

    /**
     * 查询试卷题库主列表
     */
    @Override
    public TableDataInfo<DbQuestionBankTestPaperVo> queryPageList(DbQuestionBankTestPaperBo bo, PageQuery pageQuery) {
        LambdaQueryWrapper<DbQuestionBankTestPaper> lqw = buildQueryWrapper(bo);
        Page<DbQuestionBankTestPaperVo> result = baseMapper.selectVoPage(pageQuery.build(), lqw);
        return TableDataInfo.build(result);
    }

    /**
     * 查询试卷题库主列表
     */
    @Override
    public List<DbQuestionBankTestPaperVo> queryList(DbQuestionBankTestPaperBo bo) {
        LambdaQueryWrapper<DbQuestionBankTestPaper> lqw = buildQueryWrapper(bo);
        return baseMapper.selectVoList(lqw);
    }

    private LambdaQueryWrapper<DbQuestionBankTestPaper> buildQueryWrapper(DbQuestionBankTestPaperBo bo) {
        Map<String, Object> params = bo.getParams();
        LambdaQueryWrapper<DbQuestionBankTestPaper> lqw = Wrappers.lambdaQuery();
        lqw.eq(bo.getTestPaperId() != null, DbQuestionBankTestPaper::getTestPaperId, bo.getTestPaperId());
        lqw.eq(bo.getCategoryId() != null, DbQuestionBankTestPaper::getCategoryId, bo.getCategoryId());
        lqw.eq(bo.getSpecies() != null, DbQuestionBankTestPaper::getSpecies, bo.getSpecies());
        lqw.eq(bo.getPhaseId() != null, DbQuestionBankTestPaper::getPhaseId, bo.getPhaseId());
        lqw.eq(bo.getType() != null, DbQuestionBankTestPaper::getType, bo.getType());
        lqw.eq(bo.getIntensity() != null, DbQuestionBankTestPaper::getIntensity, bo.getIntensity());
        lqw.eq(StringUtils.isNotBlank(bo.getTopic()), DbQuestionBankTestPaper::getTopic, bo.getTopic());
        lqw.eq(StringUtils.isNotBlank(bo.getRightAnswers()), DbQuestionBankTestPaper::getRightAnswers, bo.getRightAnswers());
        lqw.eq(StringUtils.isNotBlank(bo.getRightAnswersPic()), DbQuestionBankTestPaper::getRightAnswersPic, bo.getRightAnswersPic());
        lqw.eq(StringUtils.isNotBlank(bo.getResolveCourse()), DbQuestionBankTestPaper::getResolveCourse, bo.getResolveCourse());
        lqw.eq(StringUtils.isNotBlank(bo.getResolveVideo()), DbQuestionBankTestPaper::getResolveVideo, bo.getResolveVideo());
        lqw.eq(bo.getStatus() != null, DbQuestionBankTestPaper::getStatus, bo.getStatus());
        return lqw;
    }

    /**
     * 新增试卷题库主
     */
    @Override
    public Boolean insertByBo(DbQuestionBankTestPaperBo bo) {
        DbQuestionBankTestPaper add = BeanUtil.toBean(bo, DbQuestionBankTestPaper.class);
        validEntityBeforeSave(add);
        boolean flag = baseMapper.insert(add) > 0;
        if (flag) {
            bo.setId(add.getId());
        }
        return flag;
    }

    /**
     * 修改试卷题库主
     */
    @Override
    public Boolean updateByBo(DbQuestionBankTestPaperBo bo) {
        DbQuestionBankTestPaper update = BeanUtil.toBean(bo, DbQuestionBankTestPaper.class);
        validEntityBeforeSave(update);
        return baseMapper.updateById(update) > 0;
    }

    /**
     * 保存前的数据校验
     */
    private void validEntityBeforeSave(DbQuestionBankTestPaper entity) {
        //TODO 做一些数据校验,如唯一约束
    }

    /**
     * 批量删除试卷题库主
     */
    @Override
    public Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid) {
        if (isValid) {
            //TODO 做一些业务上的校验,判断是否需要校验
        }
        return baseMapper.deleteBatchIds(ids) > 0;
    }

    @Override
    public TableDataInfo<TestQuestionItemVo> getTestPaperQuestion(TestPaperAnswerBo request, PageQuery pageQuery) {
        Page<TestQuestionItemVo> result = baseMapper.selectTestPaperQuestion(pageQuery.build(), request);
        return TableDataInfo.build(result);
    }
}
