package com.ruoyi.school.paper.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.core.domain.PageQuery;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import com.ruoyi.school.paper.domain.bo.DbQuestionBankAnswerTestPaperBo;
import com.ruoyi.school.paper.domain.vo.DbQuestionBankAnswerTestPaperVo;
import com.ruoyi.school.paper.domain.DbQuestionBankAnswerTestPaper;
import com.ruoyi.school.paper.mapper.DbQuestionBankAnswerTestPaperMapper;
import com.ruoyi.school.paper.service.IDbQuestionBankAnswerTestPaperService;

import java.util.List;
import java.util.Map;
import java.util.Collection;

/**
 * 试卷题目答案Service业务层处理
 *
 * @author zyf
 * @date 2023-07-20
 */
@RequiredArgsConstructor
@Service
public class DbQuestionBankAnswerTestPaperServiceImpl implements IDbQuestionBankAnswerTestPaperService {

    private final DbQuestionBankAnswerTestPaperMapper baseMapper;

    /**
     * 查询试卷题目答案
     */
    @Override
    public DbQuestionBankAnswerTestPaperVo queryById(Long id){
        return baseMapper.selectVoById(id);
    }

    /**
     * 查询试卷题目答案列表
     */
    @Override
    public TableDataInfo<DbQuestionBankAnswerTestPaperVo> queryPageList(DbQuestionBankAnswerTestPaperBo bo, PageQuery pageQuery) {
        LambdaQueryWrapper<DbQuestionBankAnswerTestPaper> lqw = buildQueryWrapper(bo);
        Page<DbQuestionBankAnswerTestPaperVo> result = baseMapper.selectVoPage(pageQuery.build(), lqw);
        return TableDataInfo.build(result);
    }

    /**
     * 查询试卷题目答案列表
     */
    @Override
    public List<DbQuestionBankAnswerTestPaperVo> queryList(DbQuestionBankAnswerTestPaperBo bo) {
        LambdaQueryWrapper<DbQuestionBankAnswerTestPaper> lqw = buildQueryWrapper(bo);
        return baseMapper.selectVoList(lqw);
    }

    private LambdaQueryWrapper<DbQuestionBankAnswerTestPaper> buildQueryWrapper(DbQuestionBankAnswerTestPaperBo bo) {
        Map<String, Object> params = bo.getParams();
        LambdaQueryWrapper<DbQuestionBankAnswerTestPaper> lqw = Wrappers.lambdaQuery();
        lqw.eq(bo.getQuestionBankId() != null, DbQuestionBankAnswerTestPaper::getQuestionBankId, bo.getQuestionBankId());
        lqw.eq(StringUtils.isNotBlank(bo.getOptionTag()), DbQuestionBankAnswerTestPaper::getOptionTag, bo.getOptionTag());
        lqw.eq(StringUtils.isNotBlank(bo.getOptionContent()), DbQuestionBankAnswerTestPaper::getOptionContent, bo.getOptionContent());
        lqw.eq(bo.getStatus() != null, DbQuestionBankAnswerTestPaper::getStatus, bo.getStatus());
        return lqw;
    }

    /**
     * 新增试卷题目答案
     */
    @Override
    public Boolean insertByBo(DbQuestionBankAnswerTestPaperBo bo) {
        DbQuestionBankAnswerTestPaper add = BeanUtil.toBean(bo, DbQuestionBankAnswerTestPaper.class);
        validEntityBeforeSave(add);
        boolean flag = baseMapper.insert(add) > 0;
        if (flag) {
            bo.setId(add.getId());
        }
        return flag;
    }

    /**
     * 修改试卷题目答案
     */
    @Override
    public Boolean updateByBo(DbQuestionBankAnswerTestPaperBo bo) {
        DbQuestionBankAnswerTestPaper update = BeanUtil.toBean(bo, DbQuestionBankAnswerTestPaper.class);
        validEntityBeforeSave(update);
        return baseMapper.updateById(update) > 0;
    }

    /**
     * 保存前的数据校验
     */
    private void validEntityBeforeSave(DbQuestionBankAnswerTestPaper entity){
        //TODO 做一些数据校验,如唯一约束
    }

    /**
     * 批量删除试卷题目答案
     */
    @Override
    public Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid) {
        if(isValid){
            //TODO 做一些业务上的校验,判断是否需要校验
        }
        return baseMapper.deleteBatchIds(ids) > 0;
    }
}
