package com.ruoyi.school.paper.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.core.domain.PageQuery;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import com.ruoyi.school.paper.domain.bo.DbQuestionBankAnswerBo;
import com.ruoyi.school.paper.domain.vo.DbQuestionBankAnswerVo;
import com.ruoyi.school.paper.domain.DbQuestionBankAnswer;
import com.ruoyi.school.paper.mapper.DbQuestionBankAnswerMapper;
import com.ruoyi.school.paper.service.IDbQuestionBankAnswerService;

import java.util.List;
import java.util.Map;
import java.util.Collection;

/**
 * 题目答案Service业务层处理
 *
 * @author zyf
 * @date 2023-07-20
 */
@RequiredArgsConstructor
@Service
public class DbQuestionBankAnswerServiceImpl implements IDbQuestionBankAnswerService {

    private final DbQuestionBankAnswerMapper baseMapper;

    /**
     * 查询题目答案
     */
    @Override
    public DbQuestionBankAnswerVo queryById(Long id){
        return baseMapper.selectVoById(id);
    }

    /**
     * 查询题目答案列表
     */
    @Override
    public TableDataInfo<DbQuestionBankAnswerVo> queryPageList(DbQuestionBankAnswerBo bo, PageQuery pageQuery) {
        LambdaQueryWrapper<DbQuestionBankAnswer> lqw = buildQueryWrapper(bo);
        Page<DbQuestionBankAnswerVo> result = baseMapper.selectVoPage(pageQuery.build(), lqw);
        return TableDataInfo.build(result);
    }

    /**
     * 查询题目答案列表
     */
    @Override
    public List<DbQuestionBankAnswerVo> queryList(DbQuestionBankAnswerBo bo) {
        LambdaQueryWrapper<DbQuestionBankAnswer> lqw = buildQueryWrapper(bo);
        return baseMapper.selectVoList(lqw);
    }

    private LambdaQueryWrapper<DbQuestionBankAnswer> buildQueryWrapper(DbQuestionBankAnswerBo bo) {
        Map<String, Object> params = bo.getParams();
        LambdaQueryWrapper<DbQuestionBankAnswer> lqw = Wrappers.lambdaQuery();
        lqw.eq(bo.getQuestionBankId() != null, DbQuestionBankAnswer::getQuestionBankId, bo.getQuestionBankId());
        lqw.eq(StringUtils.isNotBlank(bo.getOptionTag()), DbQuestionBankAnswer::getOptionTag, bo.getOptionTag());
        lqw.eq(StringUtils.isNotBlank(bo.getOptionContent()), DbQuestionBankAnswer::getOptionContent, bo.getOptionContent());
        lqw.eq(bo.getStatus() != null, DbQuestionBankAnswer::getStatus, bo.getStatus());
        return lqw;
    }

    /**
     * 新增题目答案
     */
    @Override
    public Boolean insertByBo(DbQuestionBankAnswerBo bo) {
        DbQuestionBankAnswer add = BeanUtil.toBean(bo, DbQuestionBankAnswer.class);
        validEntityBeforeSave(add);
        boolean flag = baseMapper.insert(add) > 0;
        if (flag) {
            bo.setId(add.getId());
        }
        return flag;
    }

    /**
     * 修改题目答案
     */
    @Override
    public Boolean updateByBo(DbQuestionBankAnswerBo bo) {
        DbQuestionBankAnswer update = BeanUtil.toBean(bo, DbQuestionBankAnswer.class);
        validEntityBeforeSave(update);
        return baseMapper.updateById(update) > 0;
    }

    /**
     * 保存前的数据校验
     */
    private void validEntityBeforeSave(DbQuestionBankAnswer entity){
        //TODO 做一些数据校验,如唯一约束
    }

    /**
     * 批量删除题目答案
     */
    @Override
    public Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid) {
        if(isValid){
            //TODO 做一些业务上的校验,判断是否需要校验
        }
        return baseMapper.deleteBatchIds(ids) > 0;
    }
}
