package com.ruoyi.school.paper.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.core.domain.PageQuery;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import com.ruoyi.school.paper.domain.bo.DbProfileBo;
import com.ruoyi.school.paper.domain.vo.DbProfileVo;
import com.ruoyi.school.paper.domain.DbProfile;
import com.ruoyi.school.paper.mapper.DbProfileMapper;
import com.ruoyi.school.paper.service.IDbProfileService;

import java.util.List;
import java.util.Map;
import java.util.Collection;

/**
 * 资料Service业务层处理
 *
 * @author zyf
 * @date 2023-07-20
 */
@RequiredArgsConstructor
@Service
public class DbProfileServiceImpl implements IDbProfileService {

    private final DbProfileMapper baseMapper;

    /**
     * 查询资料
     */
    @Override
    public DbProfileVo queryById(Long id){
        return baseMapper.selectVoById(id);
    }

    /**
     * 查询资料列表
     */
    @Override
    public TableDataInfo<DbProfileVo> queryPageList(DbProfileBo bo, PageQuery pageQuery) {
        LambdaQueryWrapper<DbProfile> lqw = buildQueryWrapper(bo);
        Page<DbProfileVo> result = baseMapper.selectVoPage(pageQuery.build(), lqw);
        return TableDataInfo.build(result);
    }

    /**
     * 查询资料列表
     */
    @Override
    public List<DbProfileVo> queryList(DbProfileBo bo) {
        LambdaQueryWrapper<DbProfile> lqw = buildQueryWrapper(bo);
        return baseMapper.selectVoList(lqw);
    }

    private LambdaQueryWrapper<DbProfile> buildQueryWrapper(DbProfileBo bo) {
        Map<String, Object> params = bo.getParams();
        LambdaQueryWrapper<DbProfile> lqw = Wrappers.lambdaQuery();
        lqw.like(StringUtils.isNotBlank(bo.getProfileName()), DbProfile::getProfileName, bo.getProfileName());
        return lqw;
    }

    /**
     * 新增资料
     */
    @Override
    public Boolean insertByBo(DbProfileBo bo) {
        DbProfile add = BeanUtil.toBean(bo, DbProfile.class);
        validEntityBeforeSave(add);
        boolean flag = baseMapper.insert(add) > 0;
        if (flag) {
            bo.setId(add.getId());
        }
        return flag;
    }

    /**
     * 修改资料
     */
    @Override
    public Boolean updateByBo(DbProfileBo bo) {
        DbProfile update = BeanUtil.toBean(bo, DbProfile.class);
        validEntityBeforeSave(update);
        return baseMapper.updateById(update) > 0;
    }

    /**
     * 保存前的数据校验
     */
    private void validEntityBeforeSave(DbProfile entity){
        //TODO 做一些数据校验,如唯一约束
    }

    /**
     * 批量删除资料
     */
    @Override
    public Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid) {
        if(isValid){
            //TODO 做一些业务上的校验,判断是否需要校验
        }
        return baseMapper.deleteBatchIds(ids) > 0;
    }
}
