package com.ruoyi.school.paper.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.core.domain.PageQuery;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ruoyi.school.paper.domain.vo.MyCollectListVo;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import com.ruoyi.school.paper.domain.bo.DbCollectListBo;
import com.ruoyi.school.paper.domain.vo.DbCollectListVo;
import com.ruoyi.school.paper.domain.DbCollectList;
import com.ruoyi.school.paper.mapper.DbCollectListMapper;
import com.ruoyi.school.paper.service.IDbCollectListService;

import java.util.List;
import java.util.Map;
import java.util.Collection;

/**
 * 收藏Service业务层处理
 *
 * @author zyf
 * @date 2023-07-20
 */
@RequiredArgsConstructor
@Service
public class DbCollectListServiceImpl implements IDbCollectListService {

    private final DbCollectListMapper baseMapper;

    /**
     * 查询收藏
     */
    @Override
    public DbCollectListVo queryById(Long id) {
        return baseMapper.selectVoById(id);
    }

    /**
     * 查询收藏列表
     */
    @Override
    public TableDataInfo<MyCollectListVo> queryPageList(Integer categoryId, Long userId, PageQuery pageQuery) {
        Page<MyCollectListVo> result = baseMapper.findMyECollectListVoPage(pageQuery.build(), userId, categoryId);
        return TableDataInfo.build(result);
    }

    /**
     * 查询收藏列表
     */
    @Override
    public List<DbCollectListVo> queryList(DbCollectListBo bo) {
        LambdaQueryWrapper<DbCollectList> lqw = buildQueryWrapper(bo);
        return baseMapper.selectVoList(lqw);
    }

    private LambdaQueryWrapper<DbCollectList> buildQueryWrapper(DbCollectListBo bo) {
        Map<String, Object> params = bo.getParams();
        LambdaQueryWrapper<DbCollectList> lqw = Wrappers.lambdaQuery();
        lqw.eq(bo.getUserId() != null, DbCollectList::getUserId, bo.getUserId());
        lqw.eq(bo.getQuestionBankId() != null, DbCollectList::getQuestionBankId, bo.getQuestionBankId());
        lqw.eq(bo.getStatus() != null, DbCollectList::getStatus, bo.getStatus());
        return lqw;
    }

    /**
     * 新增收藏
     */
    @Override
    public Boolean insertByBo(DbCollectListBo bo) {
        DbCollectList add = BeanUtil.toBean(bo, DbCollectList.class);
        validEntityBeforeSave(add);
        boolean flag = baseMapper.insert(add) > 0;
        if (flag) {
            bo.setId(add.getId());
        }
        return flag;
    }

    /**
     * 修改收藏
     */
    @Override
    public Boolean updateByBo(DbCollectListBo bo) {
        DbCollectList update = BeanUtil.toBean(bo, DbCollectList.class);
        validEntityBeforeSave(update);
        return baseMapper.updateById(update) > 0;
    }

    /**
     * 保存前的数据校验
     */
    private void validEntityBeforeSave(DbCollectList entity) {
        //TODO 做一些数据校验,如唯一约束
    }

    /**
     * 批量删除收藏
     */
    @Override
    public Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid) {
        if (isValid) {
            //TODO 做一些业务上的校验,判断是否需要校验
        }
        return baseMapper.deleteBatchIds(ids) > 0;
    }
}
