package com.ruoyi.school.paper.service.impl

.paper.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.core.domain.PageQuery;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ruoyi.school.paper.domain.DbBanner;
import com.ruoyi.school.paper.domain.bo.DbBannerBo;
import com.ruoyi.school.paper.domain.vo.DbBannerVo;
import com.ruoyi.school.paper.mapper.DbBannerMapper;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import com.ruoyi.school.paper.domain.bo.DbBannerBo;
import com.ruoyi.school.paper.domain.vo.DbBannerVo;
import com.ruoyi.school.paper.domain.DbBanner;
import com.ruoyi.school.paper.mapper.DbBannerMapper;
import com.ruoyi.school.paper.service.IDbBannerService;

import java.util.List;
import java.util.Map;
import java.util.Collection;

/**
 * 轮播图Service业务层处理
 *
 * @author ruoyi
 * @date 2023.07.24
 */
@RequiredArgsConstructor
@Service
public class DbBannerServiceImpl implements IDbBannerService {

    private final DbBannerMapper baseMapper;

    /**
     * 查询轮播图
     */
    @Override
    public DbBannerVo queryById(Long id){
        return baseMapper.selectVoById(id);
    }

    /**
     * 查询轮播图列表
     */
    @Override
    public TableDataInfo<DbBannerVo> queryPageList(DbBannerBo bo, PageQuery pageQuery) {
        LambdaQueryWrapper<DbBanner> lqw = buildQueryWrapper(bo);
        Page<DbBannerVo> result = baseMapper.selectVoPage(pageQuery.build(), lqw);
        return TableDataInfo.build(result);
    }

    /**
     * 查询轮播图列表
     */
    @Override
    public List<DbBannerVo> queryList(DbBannerBo bo) {
        LambdaQueryWrapper<DbBanner> lqw = buildQueryWrapper(bo);
        return baseMapper.selectVoList(lqw);
    }

    private LambdaQueryWrapper<DbBanner> buildQueryWrapper(DbBannerBo bo) {
        Map<String, Object> params = bo.getParams();
        LambdaQueryWrapper<DbBanner> lqw = Wrappers.lambdaQuery();
        lqw.eq(StringUtils.isNotBlank(bo.getBannerTitle()), DbBanner::getBannerTitle, bo.getBannerTitle());
        lqw.eq(StringUtils.isNotBlank(bo.getUrl()), DbBanner::getUrl, bo.getUrl());
        lqw.eq(bo.getStatus() != null, DbBanner::getStatus, bo.getStatus());
        return lqw;
    }

    /**
     * 新增轮播图
     */
    @Override
    public Boolean insertByBo(DbBannerBo bo) {
        DbBanner add = BeanUtil.toBean(bo, DbBanner.class);
        validEntityBeforeSave(add);
        boolean flag = baseMapper.insert(add) > 0;
        if (flag) {
            bo.setId(add.getId());
        }
        return flag;
    }

    /**
     * 修改轮播图
     */
    @Override
    public Boolean updateByBo(DbBannerBo bo) {
        DbBanner update = BeanUtil.toBean(bo, DbBanner.class);
        validEntityBeforeSave(update);
        return baseMapper.updateById(update) > 0;
    }

    /**
     * 保存前的数据校验
     */
    private void validEntityBeforeSave(DbBanner entity){
        //TODO 做一些数据校验,如唯一约束
    }

    /**
     * 批量删除轮播图
     */
    @Override
    public Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid) {
        if(isValid){
            //TODO 做一些业务上的校验,判断是否需要校验
        }
        return baseMapper.deleteBatchIds(ids) > 0;
    }
}
