package com.ruoyi.school.paper.service;

import com.ruoyi.common.core.domain.PageQuery;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.school.paper.domain.bo.TestPaperAnswerBo;
import com.ruoyi.school.paper.domain.vo.TestPaperVo;
import com.ruoyi.school.paper.domain.vo.TestQuestionItemVo;

/**
 * 考试接口
 * <p>created in  2023/7/21 16:57
 *
 * @author WangMin
 * @version 1.0
 */
public interface ITestPaperService {


    /**
     * 生成试卷
     *
     * @param userId  用户ID
     * @param paperId 试卷ID
     * @return 试题
     */
    TestPaperVo generateTestPaper(Long userId, Long paperId);


    /**
     * 交卷
     *
     * @param bo 试题类容
     * @return 操作结果
     */
    boolean paperTestEnd(TestPaperAnswerBo bo);

    /**
     * 下一题
     *
     * @param request   请求参数 【注】考试记录ID必传
     * @param pageQuery 分页
     * @return 考试题目
     */
    TableDataInfo<TestQuestionItemVo> nextQuestion(TestPaperAnswerBo request, PageQuery pageQuery);
}
