package com.ruoyi.school.paper.service;

import com.ruoyi.school.paper.domain.DbTestPaper;
import com.ruoyi.school.paper.domain.vo.DbTestPaperVo;
import com.ruoyi.school.paper.domain.bo.DbTestPaperBo;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.core.domain.PageQuery;

import java.util.Collection;
import java.util.List;

/**
 * 试卷Service接口
 *
 * @author zyf
 * @date 2023-07-20
 */
public interface IDbTestPaperService {

    /**
     * 查询试卷
     */
    DbTestPaperVo queryById(Long id);

    /**
     * 查询试卷列表
     */
    TableDataInfo<DbTestPaperVo> queryPageList(DbTestPaperBo bo, PageQuery pageQuery);

    /**
     * 查询试卷列表
     */
    List<DbTestPaperVo> queryList(DbTestPaperBo bo);

    /**
     * 新增试卷
     */
    Boolean insertByBo(DbTestPaperBo bo);

    /**
     * 修改试卷
     */
    Boolean updateByBo(DbTestPaperBo bo);

    /**
     * 校验并批量删除试卷信息
     */
    Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);

    /**
     * 随机生成试卷
     */
    Boolean randomGeneration(DbTestPaperBo bo);
}
