package com.ruoyi.school.paper.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.ruoyi.common.core.domain.PageQuery;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.school.paper.domain.DbTestPaperRecord;
import com.ruoyi.school.paper.domain.bo.DbTestPaperRecordBo;
import com.ruoyi.school.paper.domain.vo.DbTestPaperRecordVo;

import java.util.Collection;
import java.util.List;

/**
 * 答题记录Service接口
 *
 * @author zyf
 * @date 2023-07-20
 */
public interface IDbTestPaperRecordService {

    /**
     * 查询答题记录
     */
    DbTestPaperRecordVo queryById(Long id);

    /**
     * 查询答题记录列表
     */
    TableDataInfo<DbTestPaperRecordVo> queryPageList(DbTestPaperRecordBo bo, PageQuery pageQuery);

    /**
     * 查询答题记录列表
     */
    List<DbTestPaperRecordVo> queryList(DbTestPaperRecordBo bo);

    /**
     * 新增答题记录
     */
    Boolean insertByBo(DbTestPaperRecordBo bo);

    /**
     * 修改答题记录
     */
    Boolean updateByBo(DbTestPaperRecordBo bo);

    /**
     * 校验并批量删除答题记录信息
     */
    Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);

    TableDataInfo<DbTestPaperRecordVo> testPaperlist(DbTestPaperRecordBo bo, PageQuery pageQuery);

    /**
     * 查询某条考试记录
     *
     * @param wrapper 查询条件
     * @return 结果
     */
    DbTestPaperRecord getOne(Wrapper<DbTestPaperRecord> wrapper);
}
