package com.ruoyi.school.paper.service;

import com.ruoyi.school.paper.domain.DbTestPaperRecordDetail;
import com.ruoyi.school.paper.domain.vo.DbTestPaperRecordDetailVo;
import com.ruoyi.school.paper.domain.bo.DbTestPaperRecordDetailBo;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.core.domain.PageQuery;

import java.util.Collection;
import java.util.List;

/**
 * 答题记录详情Service接口
 *
 * @author zyf
 * @date 2023-07-20
 */
public interface IDbTestPaperRecordDetailService {

    /**
     * 查询答题记录详情
     */
    DbTestPaperRecordDetailVo queryById(Long id);

    /**
     * 查询答题记录详情列表
     */
    TableDataInfo<DbTestPaperRecordDetailVo> queryPageList(DbTestPaperRecordDetailBo bo, PageQuery pageQuery);

    /**
     * 查询答题记录详情列表
     */
    List<DbTestPaperRecordDetailVo> queryList(DbTestPaperRecordDetailBo bo);

    /**
     * 新增答题记录详情
     */
    Boolean insertByBo(DbTestPaperRecordDetailBo bo);

    /**
     * 修改答题记录详情
     */
    Boolean updateByBo(DbTestPaperRecordDetailBo bo);

    /**
     * 校验并批量删除答题记录详情信息
     */
    Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);

    boolean saveBatch(Collection<DbTestPaperRecordDetail> collection);
}
