package com.ruoyi.school.paper.service;

import com.ruoyi.school.paper.domain.vo.DbQuestionTypeVo;
import com.ruoyi.school.paper.domain.bo.DbQuestionTypeBo;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.core.domain.PageQuery;

import java.util.Collection;
import java.util.List;

/**
 * 字典Service接口
 *
 * @author zyf
 * @date 2023-07-20
 */
public interface IDbQuestionTypeService {

    /**
     * 查询字典
     */
    DbQuestionTypeVo queryById(Long id);

    /**
     * 查询字典列表
     */
    TableDataInfo<DbQuestionTypeVo> queryPageList(DbQuestionTypeBo bo, PageQuery pageQuery);

    /**
     * 查询字典列表
     */
    List<DbQuestionTypeVo> queryList(DbQuestionTypeBo bo);

    /**
     * 新增字典
     */
    Boolean insertByBo(DbQuestionTypeBo bo);

    /**
     * 修改字典
     */
    Boolean updateByBo(DbQuestionTypeBo bo);

    /**
     * 校验并批量删除字典信息
     */
    Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);
}
