package com.ruoyi.school.paper.service;

import com.ruoyi.common.core.domain.PageQuery;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.school.paper.domain.bo.DbQuestionBankTestPaperBo;
import com.ruoyi.school.paper.domain.bo.TestPaperAnswerBo;
import com.ruoyi.school.paper.domain.vo.DbQuestionBankTestPaperVo;
import com.ruoyi.school.paper.domain.vo.TestQuestionItemVo;

import java.util.Collection;
import java.util.List;

/**
 * 试卷题库主Service接口
 *
 * @author zyf
 * @date 2023-07-20
 */
public interface IDbQuestionBankTestPaperService {

    /**
     * 查询试卷题库主
     */
    DbQuestionBankTestPaperVo queryById(Long id);

    /**
     * 查询试卷题库主列表
     */
    TableDataInfo<DbQuestionBankTestPaperVo> queryPageList(DbQuestionBankTestPaperBo bo, PageQuery pageQuery);

    /**
     * 查询试卷题库主列表
     */
    List<DbQuestionBankTestPaperVo> queryList(DbQuestionBankTestPaperBo bo);

    /**
     * 新增试卷题库主
     */
    Boolean insertByBo(DbQuestionBankTestPaperBo bo);

    /**
     * 修改试卷题库主
     */
    Boolean updateByBo(DbQuestionBankTestPaperBo bo);

    /**
     * 校验并批量删除试卷题库主信息
     */
    Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);


    /**
     * 查询试卷所有考题
     *
     * @return 试卷
     */
    TableDataInfo<TestQuestionItemVo> getTestPaperQuestion(TestPaperAnswerBo request, PageQuery pageQuery);
}
