package com.ruoyi.school.paper.service;

import com.ruoyi.common.core.domain.PageQuery;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.school.paper.domain.bo.DbQuestionBankBo;
import com.ruoyi.school.paper.domain.bo.QuestionBankAndAnswerBo;
import com.ruoyi.school.paper.domain.vo.DbQuestionBankAndAnswerVo;
import com.ruoyi.school.paper.domain.vo.DbQuestionBankVo;

import java.util.Collection;
import java.util.List;

/**
 * 题库主Service接口
 *
 * @author zyf
 * @date 2023-07-20
 */
public interface IDbQuestionBankService {

    /**
     * 查询题库主
     */
    DbQuestionBankVo queryById(Long id);


    /**
     * 查询题目详细信息
     *
     * @param id 题目ID
     * @return 题目信息
     */
    DbQuestionBankAndAnswerVo getById(Long id);

    /**
     * 查询题库主列表
     */
    TableDataInfo<DbQuestionBankVo> queryPageList(DbQuestionBankBo bo, PageQuery pageQuery);

    /**
     * 查询题库主列表
     */
    List<DbQuestionBankVo> queryList(DbQuestionBankBo bo);

    /**
     * 新增题库主
     */
    Boolean insertByBo(DbQuestionBankBo bo);

    /**
     * 新增题库
     *
     * @param bo 题目参数及答案列表
     * @return 操作结果
     */
    boolean insertByBo(QuestionBankAndAnswerBo bo);

    /**
     * 修改题库主
     */
    Boolean updateByBo(DbQuestionBankBo bo);

    boolean updateByBo(QuestionBankAndAnswerBo bo);

    /**
     * 校验并批量删除题库主信息
     */
    Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);

    /**
     * 初始化题库到缓存
     */
    void init();
}
