package com.ruoyi.school.paper.service;

import com.ruoyi.school.paper.domain.DbQuestionBankAnswerTestPaper;
import com.ruoyi.school.paper.domain.vo.DbQuestionBankAnswerTestPaperVo;
import com.ruoyi.school.paper.domain.bo.DbQuestionBankAnswerTestPaperBo;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.core.domain.PageQuery;

import java.util.Collection;
import java.util.List;

/**
 * 试卷题目答案Service接口
 *
 * @author zyf
 * @date 2023-07-20
 */
public interface IDbQuestionBankAnswerTestPaperService {

    /**
     * 查询试卷题目答案
     */
    DbQuestionBankAnswerTestPaperVo queryById(Long id);

    /**
     * 查询试卷题目答案列表
     */
    TableDataInfo<DbQuestionBankAnswerTestPaperVo> queryPageList(DbQuestionBankAnswerTestPaperBo bo, PageQuery pageQuery);

    /**
     * 查询试卷题目答案列表
     */
    List<DbQuestionBankAnswerTestPaperVo> queryList(DbQuestionBankAnswerTestPaperBo bo);

    /**
     * 新增试卷题目答案
     */
    Boolean insertByBo(DbQuestionBankAnswerTestPaperBo bo);

    /**
     * 修改试卷题目答案
     */
    Boolean updateByBo(DbQuestionBankAnswerTestPaperBo bo);

    /**
     * 校验并批量删除试卷题目答案信息
     */
    Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);
}
