package com.ruoyi.school.paper.service;

import com.ruoyi.school.paper.domain.DbQuestionBankAnswer;
import com.ruoyi.school.paper.domain.vo.DbQuestionBankAnswerVo;
import com.ruoyi.school.paper.domain.bo.DbQuestionBankAnswerBo;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.core.domain.PageQuery;

import java.util.Collection;
import java.util.List;

/**
 * 题目答案Service接口
 *
 * @author zyf
 * @date 2023-07-20
 */
public interface IDbQuestionBankAnswerService {

    /**
     * 查询题目答案
     */
    DbQuestionBankAnswerVo queryById(Long id);

    /**
     * 查询题目答案列表
     */
    TableDataInfo<DbQuestionBankAnswerVo> queryPageList(DbQuestionBankAnswerBo bo, PageQuery pageQuery);

    /**
     * 查询题目答案列表
     */
    List<DbQuestionBankAnswerVo> queryList(DbQuestionBankAnswerBo bo);

    /**
     * 新增题目答案
     */
    Boolean insertByBo(DbQuestionBankAnswerBo bo);

    /**
     * 修改题目答案
     */
    Boolean updateByBo(DbQuestionBankAnswerBo bo);

    /**
     * 校验并批量删除题目答案信息
     */
    Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);
}
