package com.ruoyi.school.paper.service;

import com.ruoyi.school.paper.domain.DbProfile;
import com.ruoyi.school.paper.domain.vo.DbProfileVo;
import com.ruoyi.school.paper.domain.bo.DbProfileBo;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.core.domain.PageQuery;

import java.util.Collection;
import java.util.List;

/**
 * 资料Service接口
 *
 * @author zyf
 * @date 2023-07-20
 */
public interface IDbProfileService {

    /**
     * 查询资料
     */
    DbProfileVo queryById(Long id);

    /**
     * 查询资料列表
     */
    TableDataInfo<DbProfileVo> queryPageList(DbProfileBo bo, PageQuery pageQuery);

    /**
     * 查询资料列表
     */
    List<DbProfileVo> queryList(DbProfileBo bo);

    /**
     * 新增资料
     */
    Boolean insertByBo(DbProfileBo bo);

    /**
     * 修改资料
     */
    Boolean updateByBo(DbProfileBo bo);

    /**
     * 校验并批量删除资料信息
     */
    Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);
}
