package com.ruoyi.school.paper.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ruoyi.school.paper.domain.DbErrorList;
import com.ruoyi.school.paper.domain.request.ErrorTopicRequest;
import com.ruoyi.school.paper.domain.vo.DbErrorListVo;
import com.ruoyi.school.paper.domain.bo.DbErrorListBo;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.core.domain.PageQuery;
import com.ruoyi.school.paper.domain.vo.ErrorTopicListDetailVo;
import com.ruoyi.school.paper.domain.vo.ErrorTopicListVo;
import com.ruoyi.school.paper.domain.vo.MyErrorTopicListVo;

import java.util.Collection;
import java.util.List;

/**
 * 错题集Service接口
 *
 * @author zyf
 * @date 2023-07-20
 */
public interface IDbErrorListService {

    /**
     * 查询错题集
     */
    ErrorTopicListDetailVo queryById(Long id);

    /**
     * 查询错题集列表
     */
    TableDataInfo<DbErrorListVo> queryPageList(DbErrorListBo bo, PageQuery pageQuery);

    /**
     * 查询错题集列表
     */
    List<DbErrorListVo> queryList(DbErrorListBo bo);

    /**
     * 新增错题集
     */
    Boolean insertByBo(DbErrorListBo bo);

    /**
     * 修改错题集
     */
    Boolean updateByBo(DbErrorListBo bo);

    /**
     * 校验并批量删除错题集信息
     */
    Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);

    /**
     * 错题集列表
     * @param request
     * @return
     */
    TableDataInfo<ErrorTopicListVo> findErrorTopicPage(PageQuery pageQuery,ErrorTopicRequest request);


    /**
     * 我的错题列表
     * @param pageQuery
     * @param request
     * @return
     */
    TableDataInfo<MyErrorTopicListVo> findMyErrorTopicListVoPage(PageQuery pageQuery, ErrorTopicRequest request);
}
