package com.ruoyi.school.paper.service;

import com.ruoyi.school.paper.domain.DbCollectList;
import com.ruoyi.school.paper.domain.vo.DbCollectListVo;
import com.ruoyi.school.paper.domain.bo.DbCollectListBo;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.core.domain.PageQuery;
import com.ruoyi.school.paper.domain.vo.MyCollectListVo;

import java.util.Collection;
import java.util.List;

/**
 * 收藏Service接口
 *
 * @author zyf
 * @date 2023-07-20
 */
public interface IDbCollectListService {

    /**
     * 查询收藏
     */
    DbCollectListVo queryById(Long id);

    /**
     * 查询收藏列表
     */
    TableDataInfo<MyCollectListVo> queryPageList(Integer categoryId,Long userId, PageQuery pageQuery);

    /**
     * 查询收藏列表
     */
    List<DbCollectListVo> queryList(DbCollectListBo bo);

    /**
     * 新增收藏
     */
    Boolean insertByBo(DbCollectListBo bo);

    /**
     * 修改收藏
     */
    Boolean updateByBo(DbCollectListBo bo);

    /**
     * 校验并批量删除收藏信息
     */
    Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);
}
