package com.ruoyi.school.paper.service;

import com.ruoyi.school.paper.domain.DbBanner;
import com.ruoyi.school.paper.domain.vo.DbBannerVo;
import com.ruoyi.school.paper.domain.bo.DbBannerBo;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.core.domain.PageQuery;
import com.ruoyi.school.paper.domain.bo.DbBannerBo;
import com.ruoyi.school.paper.domain.vo.DbBannerVo;

import java.util.Collection;
import java.util.List;

/**
 * 轮播图Service接口
 *
 * @author ruoyi
 * @date 2023.07.24
 */
public interface IDbBannerService {

    /**
     * 查询轮播图
     */
    DbBannerVo queryById(Long id);

    /**
     * 查询轮播图列表
     */
    TableDataInfo<DbBannerVo> queryPageList(DbBannerBo bo, PageQuery pageQuery);

    /**
     * 查询轮播图列表
     */
    List<DbBannerVo> queryList(DbBannerBo bo);

    /**
     * 新增轮播图
     */
    Boolean insertByBo(DbBannerBo bo);

    /**
     * 修改轮播图
     */
    Boolean updateByBo(DbBannerBo bo);

    /**
     * 校验并批量删除轮播图信息
     */
    Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);
}
