package com.ruoyi.school.paper.runner;

import com.ruoyi.school.paper.service.IDbQuestionBankService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;

/**
 * 初始化 system 模块对应业务数据
 *
 * @author Lion Li
 */
@Slf4j
@RequiredArgsConstructor
@Component
public class SchoolPaperApplicationRunner implements ApplicationRunner {


    private final IDbQuestionBankService questionBankService;

    @Override
    public void run(ApplicationArguments args) throws Exception {
        questionBankService.init();
        log.info("加载题库缓存数据成功");
    }

}
