package com.ruoyi.school.paper.mapper;

import com.ruoyi.school.paper.domain.DbQuestionBank;
import com.ruoyi.school.paper.domain.vo.DbQuestionBankAndAnswerVo;
import com.ruoyi.school.paper.domain.vo.DbQuestionBankVo;
import com.ruoyi.common.core.mapper.BaseMapperPlus;
import org.apache.ibatis.annotations.Mapper;

import java.io.Serializable;

/**
 * 题库主Mapper接口
 *
 * @author zyf
 * @date 2023-07-20
 */
@Mapper
public interface DbQuestionBankMapper extends BaseMapperPlus<DbQuestionBankMapper, DbQuestionBank, DbQuestionBankVo> {

    /**
     * 根据题目ID查询题目详细信息
     *
     * @param id 题目ID
     * @return 题目详细信息
     */
    DbQuestionBankAndAnswerVo selectDetailById(Serializable id);
}
