package com.ruoyi.school.paper.mapper;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ruoyi.common.core.domain.PageQuery;
import com.ruoyi.common.core.mapper.BaseMapperPlus;
import com.ruoyi.school.paper.domain.DbErrorList;
import com.ruoyi.school.paper.domain.request.ErrorTopicRequest;
import com.ruoyi.school.paper.domain.vo.DbErrorListVo;
import com.ruoyi.common.core.mapper.BaseMapperPlus;
import com.ruoyi.school.paper.domain.vo.ErrorTopicListDetailVo;
import com.ruoyi.school.paper.domain.vo.ErrorTopicListVo;
import com.ruoyi.school.paper.domain.vo.MyErrorTopicListVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import org.apache.ibatis.annotations.Mapper;

/**
 * 错题集Mapper接口
 *
 * @author zyf
 * @date 2023-07-20
 */
@Mapper
public interface DbErrorListMapper extends BaseMapperPlus<DbErrorListMapper, DbErrorList, DbErrorListVo> {
    Page<ErrorTopicListVo> findErrorTopicPage(IPage<ErrorTopicListVo> iPage, @Param("request") ErrorTopicRequest request);

    List<ErrorTopicListDetailVo> findErrorTopicListDetailById(@Param("id") Long id);

    Page<MyErrorTopicListVo> findMyErrorTopicListVoPage(IPage<ErrorTopicListVo> iPage, @Param("request") ErrorTopicRequest request);
}
