package com.ruoyi.school.paper.domain.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import lombok.Data;



/**
 * 试卷视图对象 db_test_paper
 *
 * @author zyf
 * @date 2023-07-20
 */
@Data
@ExcelIgnoreUnannotated
public class DbTestPaperVo {

    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    @ExcelProperty(value = "主键id")
    private Long id;

    /**
     * 试卷名称
     */
    @ExcelProperty(value = "试卷名称")
    private String testName;

    /**
     * 类别id
     */
    @ExcelProperty(value = "类别id")
    private Long categoryId;

    /**
     * 阶段id
     */
    @ExcelProperty(value = "阶段id")
    private Long phaseId;

    /**
     * 班级id
     */
    @ExcelProperty(value = "班级id")
    private Long classId;

    /**
     * 强度：1基础，2中等，3提高（多个中间用逗号分割）
     */
    @ExcelProperty(value = "强度：1基础，2中等，3提高（多个中间用逗号分割）")
    private String intensity;

    /**
     * 总分：100，150
     */
    @ExcelProperty(value = "总分：100，150")
    private Integer totalPoints;

    /**
     * 备注
     */
    @ExcelProperty(value = "备注")
    private String remark;

    /**
     * 状态：0正常，1删除
     */
    @ExcelProperty(value = "状态：0正常，1删除")
    private Integer status;


}
