package com.ruoyi.school.paper.domain.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.TableField;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;


/**
 * 答题记录详情视图对象 db_test_paper_record_detail
 *
 * @author zyf
 * @date 2023-07-20
 */
@Data
@ExcelIgnoreUnannotated
public class DbTestPaperRecordDetailVo {

    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    @ExcelProperty(value = "主键id")
    private Long id;

    /**
     * 记录id
     */
    @ExcelProperty(value = "记录id")
    private Long recordId;

    /**
     * 题目id
     */
    @ExcelProperty(value = "题目id")
    private Long questionBankId;

    /**
     * 答案
     */
    @ExcelProperty(value = "答案")
    private String answer;
    /**
     * 图片答案
     */
    @ExcelProperty(value = "答案")
    private String answerPic;

    /**
     * 正确答案
     */
    @ExcelProperty(value = "正确答案")
    private String correctAnswer;

    /**
     * 得分
     */
    @ExcelProperty(value = "得分")
    private BigDecimal score;

    /**
     * 是否优秀答案：0是，1不是
     */
    @ExcelProperty(value = "是否优秀答案：0是，1不是")
    private Integer good;

    /**
     * 备注
     */
    @ExcelProperty(value = "备注")
    private String remark;

    /**
     * 状态：0正常，1 删除
     */
    @ExcelProperty(value = "状态：0正常，1 删除")
    private Integer status;

    /**
     * 创建时间
     */
    @ExcelProperty(value = "创建时间")
    private Date cerateTime;

    @TableField(exist = false)
    private String topic;

    @TableField(exist = false)
    private String righAnswersPic;

    @TableField(exist = false)
    private List<DbQuestionBankAnswerTestPaperVo> answers;

    @TableField(exist = false)
    private List<GoodsAnswersVo> goodsAnswers;

}
