package com.ruoyi.school.paper.domain.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import lombok.Data;



/**
 * 试卷题库主视图对象 db_question_bank_test_paper
 *
 * @author zyf
 * @date 2023-07-20
 */
@Data
@ExcelIgnoreUnannotated
public class DbQuestionBankTestPaperVo {

    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    @ExcelProperty(value = "主键id")
    private Long id;

    /**
     * 试卷id
     */
    @ExcelProperty(value = "试卷id")
    private Long testPaperId;

    /**
     * 类别id
     */
    @ExcelProperty(value = "类别id")
    private Long categoryId;

    /**
     * 习题种类：1填空，2选择，3解答
     */
    @ExcelProperty(value = "习题种类：1填空，2选择，3解答")
    private Integer species;

    /**
     * 阶段id
     */
    @ExcelProperty(value = "阶段id")
    private Long phaseId;

    /**
     * 类型：1典例精讲
     */
    @ExcelProperty(value = "类型：1典例精讲")
    private Integer type;

    /**
     * 强度：1基础，2中等，3提高
     */
    @ExcelProperty(value = "强度：1基础，2中等，3提高")
    private Integer intensity;

    /**
     * 题目
     */
    @ExcelProperty(value = "题目")
    private String topic;

    /**
     * 正确答案
     */
    @ExcelProperty(value = "正确答案")
    private String rightAnswers;

    /**
     * 正确答案图片
     */
    @ExcelProperty(value = "正确答案图片")
    private String rightAnswersPic;

    /**
     * 解答过程
     */
    @ExcelProperty(value = "解答过程")
    private String resolveCourse;

    /**
     * 解答视频
     */
    @ExcelProperty(value = "解答视频")
    private String resolveVideo;

    /**
     * 分数
     */
    @ExcelProperty(value = "分数")
    private Integer score;

    /**
     * 备注
     */
    @ExcelProperty(value = "备注")
    private String remark;

    /**
     * 状态：0正常，1删除
     */
    @ExcelProperty(value = "状态：0正常，1删除")
    private Integer status;


}
