package com.ruoyi.school.paper.domain.bo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.ruoyi.common.core.validate.AddGroup;
import com.ruoyi.common.core.validate.EditGroup;
import lombok.Data;
import lombok.EqualsAndHashCode;
import javax.validation.constraints.*;

import java.util.Date;

import java.math.BigDecimal;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 答题记录详情业务对象 db_test_paper_record_detail
 *
 * @author zyf
 * @date 2023-07-20
 */

@Data
@EqualsAndHashCode(callSuper = true)
public class DbTestPaperRecordDetailBo extends BaseEntity {

    /**
     * 主键id
     */
    private Long id;

    /**
     * 记录id
     */
    private Long recordId;

    /**
     * 题目id
     */
    private Long questionBankId;

    /**
     * 答案
     */
    private String answer;

    /**
     * 得分
     */
    private BigDecimal score;

    /**
     * 是否优秀答案：0是，1不是
     */
    private Integer good;

    /**
     * 备注
     */
    private String remark;

    /**
     * 正确答案
     */
    private String correctAnswer;

    /**
     * 状态：0正常，1 删除
     */
    private Integer status;

    /**
     * 创建时间
     */
    private Date cerateTime;


}
