package com.ruoyi.school.paper.domain.bo;

import com.ruoyi.common.core.validate.AddGroup;
import com.ruoyi.common.core.validate.EditGroup;
import lombok.Data;
import lombok.EqualsAndHashCode;
import javax.validation.constraints.*;

import java.util.Date;

import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 答题记录业务对象 db_test_paper_record
 *
 * @author zyf
 * @date 2023-07-20
 */

@Data
@EqualsAndHashCode(callSuper = true)
public class DbTestPaperRecordBo extends BaseEntity {

    /**
     * 主键id
     */
    @NotNull(message = "主键id不能为空", groups = { EditGroup.class })
    private Long id;

    /**
     * 用户id
     */
    @NotNull(message = "用户id不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long userId;

    /**
     * 试卷id
     */
    @NotNull(message = "试卷id不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long testPaperId;

    /**
     * 状态：0 批卷中，1 批卷完成
     */
    @NotNull(message = "状态：0 批卷中，1 批卷完成不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer status;

    /**
     * 总得分
     */
    @NotNull(message = "总得分不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long totalPoints;

    /**
     * 备注
     */
    @NotBlank(message = "备注不能为空", groups = { AddGroup.class, EditGroup.class })
    private String remark;


}
