package com.ruoyi.school.paper.domain.bo;

import com.ruoyi.common.core.domain.BaseEntity;
import com.ruoyi.common.core.validate.AddGroup;
import com.ruoyi.common.core.validate.EditGroup;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 试卷业务对象 db_test_paper
 *
 * @author zyf
 * @date 2023-07-20
 */

@Data
@EqualsAndHashCode(callSuper = true)
public class DbTestPaperBo extends BaseEntity {

    /**
     * 主键id
     */
    @NotNull(message = "主键id不能为空", groups = { EditGroup.class })
    private Long id;

    /**
     * 试卷名称
     */
    @NotBlank(message = "试卷名称不能为空", groups = { AddGroup.class, EditGroup.class })
    private String testName;

    /**
     * 类别id
     */
    @NotNull(message = "类别id不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long categoryId;

    /**
     * 阶段id
     */
    @NotNull(message = "阶段id不能为空", groups = {AddGroup.class, EditGroup.class})
    private Long phaseId;

    /**
     * 班级id
     */
    @NotNull(message = "班级id不能为空", groups = {AddGroup.class, EditGroup.class})
    private Long classId;

    /**
     * 强度：1基础，2中等，3提高（多个中间用逗号分割）
     */
    @NotBlank(message = "强度不能为空", groups = {AddGroup.class, EditGroup.class})
    private String intensity;

    /**
     * 总分：100，150
     */
    @NotNull(message = "总分：100，150不能为空", groups = {AddGroup.class, EditGroup.class})
    private Integer totalPoints;

    /**
     * 备注
     */
    private String remark;

    /**
     * 状态：0正常，1删除
     */
    @NotNull(message = "状态：0正常，1删除不能为空", groups = { EditGroup.class })
    private Integer status;


}
