package com.ruoyi.school.paper.domain.bo;

import com.ruoyi.common.core.domain.BaseEntity;
import com.ruoyi.common.core.validate.AddGroup;
import com.ruoyi.common.core.validate.EditGroup;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 题型业务对象 db_question_type
 *
 * @author zyf
 * @date 2023-07-20
 */

@Data
@EqualsAndHashCode(callSuper = true)
public class DbQuestionTypeBo extends BaseEntity {

    /**
     * 主键id
     */
    @NotNull(message = "主键id不能为空", groups = { EditGroup.class })
    private Long id;

    /**
     * 父级id
     */
    @NotNull(message = "父级id不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long parentId;

    /**
     * 名称
     */
    @NotBlank(message = "名称不能为空", groups = { AddGroup.class, EditGroup.class })
    private String typeValue;

    /**
     * 备注
     */
    @NotBlank(message = "备注不能为空", groups = { AddGroup.class, EditGroup.class })
    private String remark;

    /**
     * 状态：0正常，1删除
     */
    private Integer typeStatus;


}
