package com.ruoyi.school.paper.domain.bo;

import com.ruoyi.common.core.validate.AddGroup;
import com.ruoyi.common.core.validate.EditGroup;
import lombok.Data;
import lombok.EqualsAndHashCode;
import javax.validation.constraints.*;

import java.util.Date;

import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 试卷题库主业务对象 db_question_bank_test_paper
 *
 * @author zyf
 * @date 2023-07-20
 */

@Data
@EqualsAndHashCode(callSuper = true)
public class DbQuestionBankTestPaperBo extends BaseEntity {

    /**
     * 主键id
     */
    @NotNull(message = "主键id不能为空", groups = { EditGroup.class })
    private Long id;

    /**
     * 试卷id
     */
    @NotNull(message = "试卷id不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long testPaperId;

    /**
     * 类别id
     */
    @NotNull(message = "类别id不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long categoryId;

    /**
     * 习题种类：1填空，2选择，3解答
     */
    @NotNull(message = "习题种类：1填空，2选择，3解答不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer species;

    /**
     * 阶段id
     */
    @NotNull(message = "阶段id不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long phaseId;

    /**
     * 类型：1典例精讲
     */
    @NotNull(message = "类型：1典例精讲不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer type;

    /**
     * 强度：1基础，2中等，3提高
     */
    @NotNull(message = "强度：1基础，2中等，3提高不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer intensity;

    /**
     * 题目
     */
    @NotBlank(message = "题目不能为空", groups = { AddGroup.class, EditGroup.class })
    private String topic;

    /**
     * 正确答案
     */
    @NotBlank(message = "正确答案不能为空", groups = { AddGroup.class, EditGroup.class })
    private String rightAnswers;

    /**
     * 正确答案图片
     */
    @NotBlank(message = "正确答案图片不能为空", groups = { AddGroup.class, EditGroup.class })
    private String rightAnswersPic;

    /**
     * 解答过程
     */
    @NotBlank(message = "解答过程不能为空", groups = { AddGroup.class, EditGroup.class })
    private String resolveCourse;

    /**
     * 解答视频
     */
    @NotBlank(message = "解答视频不能为空", groups = { AddGroup.class, EditGroup.class })
    private String resolveVideo;

    /**
     * 备注
     */
    @NotBlank(message = "备注不能为空", groups = { AddGroup.class, EditGroup.class })
    private String remark;

    /**
     * 状态：0正常，1删除
     */
    @NotNull(message = "状态：0正常，1删除不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer status;


}
