package com.ruoyi.school.paper.domain.bo;

import com.ruoyi.common.core.domain.BaseEntity;
import com.ruoyi.common.core.validate.AddGroup;
import com.ruoyi.common.core.validate.EditGroup;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 题目答案业务对象 db_question_bank_answer
 *
 * @author zyf
 * @date 2023-07-20
 */

@Data
@EqualsAndHashCode(callSuper = true)
public class DbQuestionBankAnswerBo extends BaseEntity {

    /**
     * 主键id
     */
    @NotNull(message = "主键id不能为空", groups = {EditGroup.class})
    private Long id;

    /**
     * 题目id
     */
    // @NotNull(message = "题目id不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long questionBankId;

    /**
     * 选项标签
     */
    @NotBlank(message = "选项标签不能为空", groups = {AddGroup.class, EditGroup.class})
    private String optionTag;

    /**
     * 选项内容
     */
    @NotBlank(message = "选项内容不能为空", groups = {AddGroup.class, EditGroup.class})
    private String optionContent;

    /**
     * 备注
     */
    // @NotBlank(message = "备注不能为空", groups = { AddGroup.class, EditGroup.class })
    private String remark;

    /**
     * 状态：0正常， 1删除
     */
    // @NotNull(message = "状态：0正常， 1删除不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer status;


}
