package com.ruoyi.school.paper.domain.bo;

import com.ruoyi.common.core.validate.AddGroup;
import com.ruoyi.common.core.validate.EditGroup;
import lombok.Data;
import lombok.EqualsAndHashCode;
import javax.validation.constraints.*;

import java.util.Date;

import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 轮播图业务对象 db_banner
 *
 * @author ruoyi
 * @date 2023-07-24
 */

@Data
@EqualsAndHashCode(callSuper = true)
public class DbBannerBo extends BaseEntity {

    /**
     * 主键id
     */
    @NotNull(message = "主键id不能为空", groups = { EditGroup.class })
    private Long id;

    /**
     * 标题
     */
    @NotBlank(message = "标题不能为空", groups = { AddGroup.class, EditGroup.class })
    private String bannerTitle;

    /**
     * 图片地址
     */
    @NotBlank(message = "图片地址不能为空", groups = { AddGroup.class, EditGroup.class })
    private String url;

    /**
     * 备注
     */
    @NotBlank(message = "备注不能为空", groups = { AddGroup.class, EditGroup.class })
    private String remark;

    /**
     * 状态：0正常，1删除
     */
    @NotNull(message = "状态：0正常，1删除不能为空", groups = { AddGroup.class, EditGroup.class })
    private Integer status;


}
