package com.ruoyi.school.paper.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ruoyi.common.core.domain.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * 答题记录详情对象 db_test_paper_record_detail
 *
 * @author zyf
 * @date 2023-07-20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("db_test_paper_record_detail")
public class DbTestPaperRecordDetail extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;
    /**
     * 记录id
     */
    private Long recordId;
    /**
     * 题目id
     */
    private Long questionBankId;
    /**
     * 答案
     */
    private String answer;

    /**
     * 图片答案
     */
    private String answersPic;
    /**
     * 正确答案
     */
    private String correctAnswer;
    /**
     * 得分
     */
    private BigDecimal score;
    /**
     * 是否优秀答案：0是，1不是
     */
    private Integer good;
    /**
     * 备注
     */
    private String remark;
    /**
     * 状态：0正常，1 删除
     */
    private Integer status;


}
