package com.ruoyi.school.paper.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ruoyi.common.core.domain.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 答题记录对象 db_test_paper_record
 *
 * @author zyf
 * @date 2023-07-20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("db_test_paper_record")
public class DbTestPaperRecord extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;
    /**
     * 用户id
     */
    private Long userId;
    /**
     * 试卷id
     */
    private Long testPaperId;
    /**
     * 状态
     * <ul>
     *     <ol>0:正在答题</ol>
     *     <ol>1:待批阅</ol>
     *     <ol>2:已批阅</ol>
     * </ul>
     */
    private Integer status;
    /**
     * 总得分
     */
    private Long totalPoints;
    /**
     * 备注
     */
    private String remark;

}
