package com.ruoyi.school.paper.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ruoyi.common.core.domain.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 试卷对象 db_test_paper
 *
 * @author zyf
 * @date 2023-07-20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("db_test_paper")
public class DbTestPaper extends BaseEntity {

    private static final long serialVersionUID=1L;

    /**
     * 主键id
     */
    @TableId(value = "id",type = IdType.AUTO)
    private Long id;
    /**
     * 试卷名称
     */
    private String testName;
    /**
     * 类别id
     */
    private Long categoryId;
    /**
     * 阶段id
     */
    private Long phaseId;
    /**
     * 班级id
     */
    private Long classId;
    /**
     * 强度：1基础，2中等，3提高（多个中间用逗号分割）
     */
    private String intensity;
    /**
     * 总分：100，150
     */
    private Integer totalPoints;
    /**
     * 备注
     */
    private String remark;
    /**
     * 状态：0正常，1删除
     */
    private Integer status;

}
