package com.ruoyi.school.paper.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ruoyi.common.core.domain.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 试卷题库主对象 db_question_bank_test_paper
 *
 * @author zyf
 * @date 2023-07-20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("db_question_bank_test_paper")
public class DbQuestionBankTestPaper extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;
    /**
     * 题库id
     */
    private Long questionBankId;
    /**
     * 试卷id
     */
    private Long testPaperId;
    /**
     * 类别id
     */
    private Long categoryId;
    /**
     * 习题种类：1填空，2选择，3解答
     */
    private Integer species;
    /**
     * 阶段id
     */
    private Long phaseId;
    /**
     * 类型：1典例精讲
     */
    private Integer type;
    /**
     * 强度：1基础，2中等，3提高
     */
    private Integer intensity;
    /**
     * 题目
     */
    private String topic;
    /**
     * 正确答案
     */
    private String rightAnswers;
    /**
     * 正确答案图片
     */
    private String rightAnswersPic;
    /**
     * 解答过程
     */
    private String resolveCourse;
    /**
     * 解答视频
     */
    private String resolveVideo;
    /**
     * 分数
     */
    private Integer score;
    /**
     * 备注
     */
    private String remark;
    /**
     * 状态：0正常，1删除
     */
    private Integer status;

}
