package com.ruoyi.school.paper.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ruoyi.common.core.domain.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 题目答案对象 db_question_bank_answer
 *
 * @author zyf
 * @date 2023-07-20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("db_question_bank_answer")
public class DbQuestionBankAnswer extends BaseEntity {

    private static final long serialVersionUID=1L;

    /**
     * 主键id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;
    /**
     * 题目id
     */
    private Long questionBankId;
    /**
     * 选项标签
     */
    private String optionTag;
    /**
     * 选项内容
     */
    private String optionContent;
    /**
     * 备注
     */
    private String remark;
    /**
     * 状态：0正常， 1删除
     */
    private Integer status;

}
