package com.ruoyi.school.paper.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ruoyi.common.core.domain.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 错题集对象 db_error_list
 *
 * @author zyf
 * @date 2023-07-20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("db_error_list")
public class DbErrorList extends BaseEntity {

    private static final long serialVersionUID=1L;

    /**
     * 主键id
     */
    @TableId(value = "id",type = IdType.AUTO)
    private Long id;
    /**
     * 用户id
     */
    private Long userId;
    /**
     * 试卷id
     */
    private Long paperId;
    /**
     * 题目id
     */
    private Long questionBankId;

    /**
     * 答题记录编号
     */
    private Long recordId;
    /**
     * 备注
     */
    private String remark;
    /**
     * 状态：0正常，1删除
     */
    private Integer status;

}
