package com.ruoyi.school.paper.domain;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.io.Serializable;
import java.util.Date;
import java.math.BigDecimal;

import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 轮播图对象 db_banner
 *
 * @author ruoyi
 * @date 2023-07-24
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("db_banner")
public class DbBanner extends BaseEntity {

    private static final long serialVersionUID=1L;

    /**
     * 主键id
     */
    @TableId(value = "id")
    private Long id;
    /**
     * 标题
     */
    private String bannerTitle;
    /**
     * 图片地址
     */
    private String url;
    /**
     * 备注
     */
    private String remark;
    /**
     * 状态：0正常，1删除
     */
    private Integer status;

}
