package com.ruoyi.school.paper.controller;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.PageQuery;
import com.ruoyi.common.core.domain.R;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.school.paper.domain.bo.TestPaperAnswerBo;
import com.ruoyi.school.paper.domain.vo.TestPaperVo;
import com.ruoyi.school.paper.domain.vo.TestQuestionItemVo;
import com.ruoyi.school.paper.service.ITestPaperService;
import lombok.RequiredArgsConstructor;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotNull;
import java.util.Objects;

/**
 * 考试
 * <p>created in  2023/7/21 16:20
 *
 * @author WangMin
 * @version 1.0
 */
@Validated
@RequiredArgsConstructor
@RestController
@RequestMapping("/school-paper/test")
public class TestPaperController extends BaseController {

    private final ITestPaperService testPaperService;

    /**
     * [小程序端]开始考试
     *
     * @return 试卷
     */
    @Log(title = "开始考试", businessType = BusinessType.OTHER)
    @GetMapping("/startTest/{paperId}")
    public R<TestPaperVo> startTest(@NotNull(message = "试卷ID不能为空") @PathVariable("paperId") Long paperId) {
        Long userId = getUserId();
        Objects.requireNonNull(userId, "未检查到合法账户信息");
        return R.ok(testPaperService.generateTestPaper(userId, paperId));
    }

    /**
     * [小程序端]下一题
     *
     * @param request   请求参数 【注】考试记录ID必传
     * @param pageQuery 分页
     * @return 考试题目
     */
    @Log(title = "下一题", businessType = BusinessType.OTHER)
    @PostMapping("/next")
    public TableDataInfo<TestQuestionItemVo> nextQuestion(@RequestBody TestPaperAnswerBo request, @RequestBody PageQuery pageQuery) {
        return testPaperService.nextQuestion(request, pageQuery);
    }

    /**
     * [小程序端]交卷
     *
     * @param bo 试卷参数
     * @return 无返回值
     */
    @Log(title = "交卷", businessType = BusinessType.INSERT)
    @PostMapping("/endTest/")
    public R<Void> paperTestEnd(@RequestBody TestPaperAnswerBo bo) {
        return toAjax(testPaperService.paperTestEnd(bo));
    }


}
