package com.ruoyi.school.paper.controller;

import cn.dev33.satoken.annotation.SaIgnore;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.annotation.RepeatSubmit;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.PageQuery;
import com.ruoyi.common.core.domain.R;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.core.validate.AddGroup;
import com.ruoyi.common.core.validate.EditGroup;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.school.paper.domain.bo.DbTestPaperRecordDetailBo;
import com.ruoyi.school.paper.domain.vo.DbTestPaperRecordDetailVo;
import com.ruoyi.school.paper.service.IDbTestPaperRecordDetailService;
import lombok.RequiredArgsConstructor;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.Arrays;
import java.util.List;

/**
 * 答题记录详情
 *
 * @author zyf
 * @date 2023-07-20
 */
@Validated
@RequiredArgsConstructor
@RestController
@RequestMapping("/school-paper/testPaperRecordDetail")
@SaIgnore
public class DbTestPaperRecordDetailController extends BaseController {

    private final IDbTestPaperRecordDetailService iDbTestPaperRecordDetailService;

    /**
     * 【小程序】查询答题记录详情列表
     */
    @GetMapping("/list")
    public TableDataInfo<DbTestPaperRecordDetailVo> list(DbTestPaperRecordDetailBo bo, PageQuery pageQuery) {
        return iDbTestPaperRecordDetailService.queryPageList(bo, pageQuery);
    }

    /**
     * 导出答题记录详情列表
     */
    @Log(title = "答题记录详情", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(DbTestPaperRecordDetailBo bo, HttpServletResponse response) {
        List<DbTestPaperRecordDetailVo> list = iDbTestPaperRecordDetailService.queryList(bo);
        ExcelUtil.exportExcel(list, "答题记录详情", DbTestPaperRecordDetailVo.class, response);
    }

    /**
     * 获取答题记录详情详细信息
     *
     * @param id 主键
     */
    @GetMapping("/{id}")
    public R<DbTestPaperRecordDetailVo> getInfo(@NotNull(message = "主键不能为空")
                                     @PathVariable Long id) {
        return R.ok(iDbTestPaperRecordDetailService.queryById(id));
    }

    /**
     * 新增答题记录详情
     */
    @Log(title = "答题记录详情", businessType = BusinessType.INSERT)
    @RepeatSubmit()
    @PostMapping()
    public R<Void> add(@Validated(AddGroup.class) @RequestBody DbTestPaperRecordDetailBo bo) {
        return toAjax(iDbTestPaperRecordDetailService.insertByBo(bo));
    }

    /**
     * 修改答题记录详情
     */
    @Log(title = "答题记录详情", businessType = BusinessType.UPDATE)
    @RepeatSubmit()
    @PutMapping()
    public R<Void> edit(@Validated(EditGroup.class) @RequestBody DbTestPaperRecordDetailBo bo) {
        return toAjax(iDbTestPaperRecordDetailService.updateByBo(bo));
    }

    /**
     * 删除答题记录详情
     *
     * @param ids 主键串
     */
    @Log(title = "答题记录详情", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public R<Void> remove(@NotEmpty(message = "主键不能为空")
                          @PathVariable Long[] ids) {
        return toAjax(iDbTestPaperRecordDetailService.deleteWithValidByIds(Arrays.asList(ids), true));
    }
}
