package com.ruoyi.school.paper.controller;

import cn.dev33.satoken.annotation.SaIgnore;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.annotation.RepeatSubmit;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.PageQuery;
import com.ruoyi.common.core.domain.R;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.core.validate.AddGroup;
import com.ruoyi.common.core.validate.EditGroup;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.helper.LoginHelper;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.school.paper.domain.bo.DbTestPaperRecordBo;
import com.ruoyi.school.paper.domain.vo.DbTestPaperRecordVo;
import com.ruoyi.school.paper.service.IDbTestPaperRecordService;
import lombok.RequiredArgsConstructor;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.Arrays;
import java.util.List;

/**
 * 答题记录
 *
 * @author zyf
 * @date 2023-07-20
 */
@Validated
@RequiredArgsConstructor
@RestController
@RequestMapping("/school-paper/testPaperRecord")
@SaIgnore
public class DbTestPaperRecordController extends BaseController {

    private final IDbTestPaperRecordService iDbTestPaperRecordService;

    /**
     * 查询答题记录列表
     */
    @GetMapping("/list")
    public TableDataInfo<DbTestPaperRecordVo> list(DbTestPaperRecordBo bo, PageQuery pageQuery) {
        return iDbTestPaperRecordService.queryPageList(bo, pageQuery);
    }

    /**
     * 【小程序】查询答题记录列表
     */
    @GetMapping("/testPaperlist")
    public TableDataInfo<DbTestPaperRecordVo> testPaperlist(DbTestPaperRecordBo bo, PageQuery pageQuery) {
        Long userId = LoginHelper.getUserId();
        bo.setUserId(userId);
        return iDbTestPaperRecordService.testPaperlist(bo, pageQuery);
    }

    /**
     * 导出答题记录列表
     */
    @Log(title = "答题记录", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(DbTestPaperRecordBo bo, HttpServletResponse response) {
        List<DbTestPaperRecordVo> list = iDbTestPaperRecordService.queryList(bo);
        ExcelUtil.exportExcel(list, "答题记录", DbTestPaperRecordVo.class, response);
    }

    /**
     * 获取答题记录详细信息
     *
     * @param id 主键
     */
    @GetMapping("/{id}")
    public R<DbTestPaperRecordVo> getInfo(@NotNull(message = "主键不能为空")
                                     @PathVariable Long id) {
        return R.ok(iDbTestPaperRecordService.queryById(id));
    }

    /**
     * 新增答题记录
     */
    @Log(title = "答题记录", businessType = BusinessType.INSERT)
    @RepeatSubmit()
    @PostMapping()
    public R<Void> add(@Validated(AddGroup.class) @RequestBody DbTestPaperRecordBo bo) {
        return toAjax(iDbTestPaperRecordService.insertByBo(bo));
    }

    /**
     * 修改答题记录
     */
    @Log(title = "答题记录", businessType = BusinessType.UPDATE)
    @RepeatSubmit()
    @PutMapping()
    public R<Void> edit(@Validated(EditGroup.class) @RequestBody DbTestPaperRecordBo bo) {
        return toAjax(iDbTestPaperRecordService.updateByBo(bo));
    }

    /**
     * 删除答题记录
     *
     * @param ids 主键串
     */
    @Log(title = "答题记录", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public R<Void> remove(@NotEmpty(message = "主键不能为空")
                          @PathVariable Long[] ids) {
        return toAjax(iDbTestPaperRecordService.deleteWithValidByIds(Arrays.asList(ids), true));
    }
}
