package com.ruoyi.school.paper.controller;

import cn.dev33.satoken.annotation.SaIgnore;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.annotation.RepeatSubmit;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.PageQuery;
import com.ruoyi.common.core.domain.R;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.core.validate.AddGroup;
import com.ruoyi.common.core.validate.EditGroup;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.school.paper.domain.bo.DbQuestionTypeBo;
import com.ruoyi.school.paper.domain.vo.DbQuestionTypeVo;
import com.ruoyi.school.paper.service.IDbQuestionTypeService;
import lombok.RequiredArgsConstructor;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.Arrays;
import java.util.List;

/**
 * 题型
 *
 * @author zyf
 * @date 2023-07-20
 */
@Validated
@RequiredArgsConstructor
@RestController
@RequestMapping("/school-paper/question-type")
@SaIgnore
public class DbQuestionTypeController extends BaseController {

    private final IDbQuestionTypeService iDbQuestionTypeService;

    /**
     * [PC端/小程序端]查询题型列表
     */
    @GetMapping("/list")
    public TableDataInfo<DbQuestionTypeVo> list(DbQuestionTypeBo bo, PageQuery pageQuery) {
        return iDbQuestionTypeService.queryPageList(bo, pageQuery);
    }

    /**
     * [PC端]导出题型列表
     */
    @Log(title = "题型", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(DbQuestionTypeBo bo, HttpServletResponse response) {
        List<DbQuestionTypeVo> list = iDbQuestionTypeService.queryList(bo);
        ExcelUtil.exportExcel(list, "题型", DbQuestionTypeVo.class, response);
    }

    /**
     * [PC端/小程序端]获取题型详细信息
     *
     * @param id 主键
     */
    @GetMapping("/{id}")
    public R<DbQuestionTypeVo> getInfo(@NotNull(message = "主键不能为空")
                                     @PathVariable Long id) {
        return R.ok(iDbQuestionTypeService.queryById(id));
    }

    /**
     * [PC端]新增题型
     */
    @Log(title = "题型", businessType = BusinessType.INSERT)
    @RepeatSubmit()
    @PostMapping()
    public R<Void> add(@Validated(AddGroup.class) @RequestBody DbQuestionTypeBo bo) {
        return toAjax(iDbQuestionTypeService.insertByBo(bo));
    }

    /**
     * [PC端]修改题型
     */
    @Log(title = "题型", businessType = BusinessType.UPDATE)
    @RepeatSubmit()
    @PutMapping()
    public R<Void> edit(@Validated(EditGroup.class) @RequestBody DbQuestionTypeBo bo) {
        return toAjax(iDbQuestionTypeService.updateByBo(bo));
    }

    /**
     * [PC端]删除题型
     *
     * @param ids 主键串
     */
    @Log(title = "题型", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public R<Void> remove(@NotEmpty(message = "主键不能为空")
                          @PathVariable Long[] ids) {
        return toAjax(iDbQuestionTypeService.deleteWithValidByIds(Arrays.asList(ids), true));
    }
}
